
import gurobipy as gp

# Create a new model
m = gp.Model("worker_optimization")

# Create variables
george_hours = m.addVar(name="george_hours")
bill_hours = m.addVar(name="bill_hours")
peggy_hours = m.addVar(name="peggy_hours")
ringo_hours = m.addVar(name="ringo_hours")

# Set objective function
m.setObjective(1.9 * george_hours + 2.09 * bill_hours + 5.6 * peggy_hours + 2.2 * ringo_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * bill_hours + 2 * ringo_hours >= 13, "c1")
m.addConstr(4 * bill_hours + 11 * peggy_hours + 2 * ringo_hours >= 15, "c2")
m.addConstr(7 * george_hours + 11 * peggy_hours + 2 * ringo_hours >= 15, "c3")
m.addConstr(7 * george_hours + 4 * bill_hours + 11 * peggy_hours >= 15, "c4")
m.addConstr(4 * bill_hours + 11 * peggy_hours + 2 * ringo_hours >= 21, "c5")
m.addConstr(7 * george_hours + 11 * peggy_hours + 2 * ringo_hours >= 21, "c6")
m.addConstr(7 * george_hours + 4 * bill_hours + 11 * peggy_hours >= 21, "c7")
m.addConstr(4 * bill_hours + 11 * peggy_hours + 2 * ringo_hours >= 17, "c8")
m.addConstr(7 * george_hours + 11 * peggy_hours + 2 * ringo_hours >= 17, "c9")
m.addConstr(7 * george_hours + 4 * bill_hours + 11 * peggy_hours >= 17, "c10")
m.addConstr(3 * bill_hours + 6 * peggy_hours + 8 * ringo_hours >= 19, "c11")
m.addConstr(4 * bill_hours + 11 * peggy_hours <= 92, "c12")
m.addConstr(7 * george_hours + 11 * peggy_hours <= 58, "c13")
m.addConstr(11 * peggy_hours + 2 * ringo_hours <= 84, "c14")
m.addConstr(7 * george_hours + 4 * bill_hours + 11 * peggy_hours <= 54, "c15")
m.addConstr(7 * george_hours + 4 * bill_hours + 11 * peggy_hours + 2 * ringo_hours <= 54, "c16")
m.addConstr(3 * bill_hours + 6 * peggy_hours <= 27, "c17")
m.addConstr(3 * bill_hours + 8 * ringo_hours <= 73, "c18")
m.addConstr(8 * george_hours + 8 * ringo_hours <= 37, "c19")
m.addConstr(6 * peggy_hours + 8 * ringo_hours <= 73, "c20")
m.addConstr(8 * george_hours + 3 * bill_hours + 6 * peggy_hours + 8 * ringo_hours <= 73, "c21")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

