
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
G = m.addVar(lb=0, name="hours_worked_by_George")
B = m.addVar(lb=0, name="hours_worked_by_Bill")
P = m.addVar(lb=0, name="hours_worked_by_Peggy")
R = m.addVar(lb=0, name="hours_worked_by_Ringo")

# Define the objective function
m.setObjective(1.9*G + 2.09*B + 5.6*P + 2.2*R, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(4*B + 2*R >= 13, name="constraint_1")
m.addConstr(4*B + 11*P + 2*R >= 15, name="constraint_2")
m.addConstr(7*G + 11*P + 2*R >= 15, name="constraint_3")
m.addConstr(7*G + 4*B + 11*P >= 15, name="constraint_4")
m.addConstr(4*B + 11*P + 2*R >= 21, name="constraint_5")
m.addConstr(7*G + 11*P + 2*R >= 21, name="constraint_6")
m.addConstr(7*G + 4*B + 11*P >= 21, name="constraint_7")
m.addConstr(4*B + 11*P + 2*R >= 17, name="constraint_8")
m.addConstr(7*G + 11*P + 2*R >= 17, name="constraint_9")
m.addConstr(7*G + 4*B + 11*P >= 17, name="constraint_10")
m.addConstr(3*B + 6*P + 8*R >= 19, name="constraint_11")
m.addConstr(4*B + 11*P <= 92, name="constraint_12")
m.addConstr(7*G + 11*P <= 58, name="constraint_13")
m.addConstr(11*P + 2*R <= 84, name="constraint_14")
m.addConstr(7*G + 4*B + 11*P <= 54, name="constraint_15")
m.addConstr(7*G + 4*B + 11*P + 2*R <= 54, name="constraint_16")
m.addConstr(3*B + 6*P <= 27, name="constraint_17")
m.addConstr(3*B + 8*R <= 73, name="constraint_18")
m.addConstr(8*G + 8*R <= 37, name="constraint_19")
m.addConstr(6*P + 8*R <= 73, name="constraint_20")
m.addConstr(8*G + 3*B + 6*P + 8*R <= 73, name="constraint_21")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by George: ", G.varValue)
    print("Hours worked by Bill: ", B.varValue)
    print("Hours worked by Peggy: ", P.varValue)
    print("Hours worked by Ringo: ", R.varValue)
else:
    print("The problem is infeasible")
