
from gurobipy import Model, GRB

# Create a new model
m = Model("resource_allocation")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="military_intelligence_companies")
x1 = m.addVar(vtype=GRB.INTEGER, name="transportation_companies")
x2 = m.addVar(vtype=GRB.INTEGER, name="water_purification_units")

# Set objective function
m.setObjective(3.34 * x0 + 7.58 * x1 + 8.16 * x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.9 * x0 + 5.21 * x2 >= 31, "c1")
m.addConstr(0.9 * x0 + 2.23 * x1 >= 23, "c2")
m.addConstr(2.23 * x1 + 5.21 * x2 >= 37, "c3")
m.addConstr(0.9 * x0 + 2.23 * x1 + 5.21 * x2 >= 37, "c4")
m.addConstr(3.14 * x0 + 1.42 * x1 >= 28, "c5")
m.addConstr(3.14 * x0 + 3.04 * x2 >= 20, "c6")
m.addConstr(1.42 * x1 + 3.04 * x2 >= 29, "c7")
m.addConstr(3.14 * x0 + 1.42 * x1 + 3.04 * x2 >= 29, "c8")


# Resource upper bounds (implicitly handled by other constraints, but included for completeness)
m.addConstr(0.9 * x0 + 2.23 * x1 <= 139, "offensive_capability_upper_bound") # Redundant
m.addConstr(3.14 * x0 + 1.42 * x1 <= 45, "deployment_weight_upper_bound_x0_x1")
m.addConstr(3.14 * x0 + 1.42 * x1 + 3.04 * x2 <= 127, "deployment_weight_upper_bound") # Redundant


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('x0:', x0.x)
    print('x1:', x1.x)
    print('x2:', x2.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

