
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="military_intelligence_companies", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="transportation_companies", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="water_purification_units", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(3.34*x0 + 7.58*x1 + 8.16*x2, gp.GRB.MINIMIZE)

# Offensive Capability Rating Constraints
m.addConstr(0.9*x0 + 5.21*x2 >= 31, name="offensive_capability_rating_1")
m.addConstr(0.9*x0 + 2.23*x1 >= 23, name="offensive_capability_rating_2")
m.addConstr(2.23*x1 + 5.21*x2 >= 37, name="offensive_capability_rating_3")
m.addConstr(0.9*x0 + 2.23*x1 + 5.21*x2 >= 37, name="offensive_capability_rating_4")

# Deployment Weight Constraints
m.addConstr(3.14*x0 + 1.42*x1 >= 28, name="deployment_weight_1")
m.addConstr(3.14*x0 + 3.04*x2 >= 20, name="deployment_weight_2")
m.addConstr(1.42*x1 + 3.04*x2 >= 29, name="deployment_weight_3")
m.addConstr(3.14*x0 + 1.42*x1 + 3.04*x2 >= 29, name="deployment_weight_4")
m.addConstr(3.14*x0 + 1.42*x1 <= 45, name="deployment_weight_5")

# Non-negativity constraints
m.addConstr(x0 >= 0, name="non_negativity_x0")
m.addConstr(x1 >= 0, name="non_negativity_x1")
m.addConstr(x2 >= 0, name="non_negativity_x2")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Military Intelligence Companies: {x0.varValue}")
    print(f"Transportation Companies: {x1.varValue}")
    print(f"Water Purification Units: {x2.varValue}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
