
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_k")
protein = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein")
vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")
calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")
potassium = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="potassium")

# Set objective function
m.setObjective(6 * vitamin_k + 7 * protein + 5 * vitamin_b3 + 4 * calcium + 1 * potassium, gp.GRB.MAXIMIZE)

# Add resource constraints
m.addConstr(2 * vitamin_k + 6 * protein + 2 * vitamin_b3 + 6 * calcium + 5 * potassium <= 257, "r0") #cognitive performance index
m.addConstr(6 * vitamin_k + 6 * protein + 2 * vitamin_b3 + 3 * calcium + 1 * potassium <= 227, "r1") #kidney support index
m.addConstr(5 * vitamin_k + 6 * protein + 1 * vitamin_b3 + 6 * calcium + 1 * potassium <= 74, "r2") #digestive support index


# Add additional kidney support index constraints
m.addConstr(6 * vitamin_k + 2 * vitamin_b3 + 1 * potassium >= 44)
m.addConstr(6 * protein + 3 * calcium + 1 * potassium >= 44)
m.addConstr(6 * vitamin_k + 6 * protein + 1 * potassium >= 44)
m.addConstr(6 * vitamin_k + 2 * vitamin_b3 + 3 * calcium >= 44)
m.addConstr(2 * vitamin_b3 + 3 * calcium + 1 * potassium >= 44)
m.addConstr(6 * protein + 2 * vitamin_b3 + 1 * potassium >= 44)
m.addConstr(6 * vitamin_k + 6 * protein + 2 * vitamin_b3 >= 44)
m.addConstr(6 * vitamin_k + 2 * vitamin_b3 + 1 * potassium >= 43)
m.addConstr(6 * protein + 3 * calcium + 1 * potassium >= 43)
m.addConstr(6 * vitamin_k + 6 * protein + 1 * potassium >= 43)
m.addConstr(6 * vitamin_k + 2 * vitamin_b3 + 3 * calcium >= 43)
m.addConstr(2 * vitamin_b3 + 3 * calcium + 1 * potassium >= 43)
m.addConstr(6 * protein + 2 * vitamin_b3 + 1 * potassium >= 43)
m.addConstr(6 * vitamin_k + 6 * protein + 2 * vitamin_b3 >= 43)
m.addConstr(6 * vitamin_k + 2 * vitamin_b3 + 1 * potassium >= 38)
m.addConstr(6 * protein + 3 * calcium + 1 * potassium >= 38)
m.addConstr(6 * vitamin_k + 6 * protein + 1 * potassium >= 38)
m.addConstr(6 * vitamin_k + 2 * vitamin_b3 + 3 * calcium >= 38)
m.addConstr(2 * vitamin_b3 + 3 * calcium + 1 * potassium >= 38)
m.addConstr(6 * protein + 2 * vitamin_b3 + 1 * potassium >= 38)
m.addConstr(6 * vitamin_k + 6 * protein + 2 * vitamin_b3 >= 38)
m.addConstr(6 * vitamin_k + 2 * vitamin_b3 + 1 * potassium >= 32)
m.addConstr(6 * protein + 3 * calcium + 1 * potassium >= 32)
m.addConstr(6 * vitamin_k + 6 * protein + 1 * potassium >= 32)
m.addConstr(6 * vitamin_k + 2 * vitamin_b3 + 3 * calcium >= 32)
m.addConstr(2 * vitamin_b3 + 3 * calcium + 1 * potassium >= 32)
m.addConstr(6 * protein + 2 * vitamin_b3 + 1 * potassium >= 32)
m.addConstr(6 * vitamin_k + 6 * protein + 2 * vitamin_b3 >= 32)
m.addConstr(6 * vitamin_k + 2 * vitamin_b3 + 1 * potassium >= 45)
m.addConstr(6 * protein + 3 * calcium + 1 * potassium >= 45)
m.addConstr(6 * vitamin_k + 6 * protein + 1 * potassium >= 45)
m.addConstr(6 * vitamin_k + 2 * vitamin_b3 + 3 * calcium >= 45)
m.addConstr(2 * vitamin_b3 + 3 * calcium + 1 * potassium >= 45)
m.addConstr(6 * protein + 2 * vitamin_b3 + 1 * potassium >= 45)
m.addConstr(6 * vitamin_k + 6 * protein + 2 * vitamin_b3 >= 45)
m.addConstr(6 * vitamin_k + 2 * vitamin_b3 + 1 * potassium >= 24)
m.addConstr(6 * protein + 3 * calcium + 1 * potassium >= 24)
m.addConstr(6 * vitamin_k + 6 * protein + 1 * potassium >= 24)
m.addConstr(6 * vitamin_k + 2 * vitamin_b3 + 3 * calcium >= 24)
m.addConstr(2 * vitamin_b3 + 3 * calcium + 1 * potassium >= 24)
m.addConstr(6 * protein + 2 * vitamin_b3 + 1 * potassium >= 24)
m.addConstr(6 * vitamin_k + 6 * protein + 2 * vitamin_b3 >= 24)
m.addConstr(6 * vitamin_k + 2 * vitamin_b3 + 1 * potassium >= 37)
m.addConstr(6 * protein + 3 * calcium + 1 * potassium >= 37)
m.addConstr(6 * vitamin_k + 6 * protein + 1 * potassium >= 37)
m.addConstr(6 * vitamin_k + 2 * vitamin_b3 + 3 * calcium >= 37)
m.addConstr(2 * vitamin_b3 + 3 * calcium + 1 * potassium >= 37)
m.addConstr(6 * protein + 2 * vitamin_b3 + 1 * potassium >= 37)
m.addConstr(6 * vitamin_k + 6 * protein + 2 * vitamin_b3 >= 37)


#Add additional digestive support index constraints
m.addConstr(5 * vitamin_k + 6 * calcium >= 6)
m.addConstr(6 * protein + 1 * vitamin_b3 >= 9)
m.addConstr(6 * protein + 1 * potassium >= 14)
m.addConstr(5 * vitamin_k + 1 * potassium >= 8)
m.addConstr(1 * vitamin_b3 + 6 * calcium >= 5)
m.addConstr(5 * vitamin_k + 6 * protein >= 4)

# Add other constraints
m.addConstr(-7 * protein - 7 * calcium + 1 * potassium >= 0)
m.addConstr(2 * vitamin_k + 6 * protein <= 222)
m.addConstr(6 * protein + 5 * potassium <= 165)
m.addConstr(2 * vitamin_b3 + 6 * calcium <= 175)
m.addConstr(2 * vitamin_k + 6 * protein + 2 * vitamin_b3 + 6 * calcium + 5 * potassium <= 175)
m.addConstr(2 * vitamin_b3 + 3 * calcium <= 47)
m.addConstr(2 * vitamin_b3 + potassium <= 200)
m.addConstr(6 * protein + 2 * vitamin_b3 <= 139)
m.addConstr(6 * vitamin_k + 6 * protein + 2 * vitamin_b3 + 3 * calcium + potassium <= 139)
m.addConstr(6 * protein + 1 * vitamin_b3 <= 39)
m.addConstr(6 * protein + potassium <= 18)
m.addConstr(5 * vitamin_k + potassium <= 56)
m.addConstr(5 * vitamin_k + 1 * vitamin_b3 <= 72)
m.addConstr(5 * vitamin_k + 6 * calcium <= 63)
m.addConstr(6 * protein + 6 * calcium <= 31)
m.addConstr(1 * vitamin_b3 + 6 * calcium <= 30)
m.addConstr(5 * vitamin_k + 6 * protein + 1 * vitamin_b3 + 6 * calcium + potassium <= 30)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

