
from gurobipy import Model, GRB

# Create a new model
model = Model("Resource Allocation")

# Define decision variables
hank_hours = model.addVar(vtype=GRB.INTEGER, name="hank_hours")
bobby_hours = model.addVar(vtype=GRB.INTEGER, name="bobby_hours")
laura_hours = model.addVar(vtype=GRB.INTEGER, name="laura_hours")
paul_hours = model.addVar(vtype=GRB.INTEGER, name="paul_hours")
peggy_hours = model.addVar(vtype=GRB.CONTINUOUS, name="peggy_hours")  # Peggy's hours can be non-integer

# Set objective function
model.setObjective(2.55 * hank_hours + 7.28 * bobby_hours + 5.19 * laura_hours + 8.05 * paul_hours + 9.52 * peggy_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(25 * laura_hours + 8 * paul_hours >= 59, "c1")
model.addConstr(30 * hank_hours + 25 * laura_hours >= 92, "c2")
model.addConstr(14 * bobby_hours + 25 * laura_hours >= 57, "c3")
model.addConstr(14 * bobby_hours + 14 * peggy_hours >= 54, "c4")
model.addConstr(14 * bobby_hours + 8 * paul_hours >= 74, "c5")
model.addConstr(30 * hank_hours + 14 * bobby_hours + 8 * paul_hours >= 58, "c6")
model.addConstr(14 * bobby_hours + 25 * laura_hours + 14 * peggy_hours >= 58, "c7")
model.addConstr(30 * hank_hours + 14 * bobby_hours + 8 * paul_hours >= 51, "c8")
model.addConstr(14 * bobby_hours + 25 * laura_hours + 14 * peggy_hours >= 51, "c9")
model.addConstr(20 * laura_hours + 24 * paul_hours + 9 * peggy_hours >= 25, "c10")
model.addConstr(18 * bobby_hours + 20 * laura_hours + 24 * paul_hours >= 25, "c11")
model.addConstr(20 * laura_hours + 24 * paul_hours + 9 * peggy_hours >= 29, "c12")
model.addConstr(18 * bobby_hours + 20 * laura_hours + 24 * paul_hours >= 29, "c13")
model.addConstr(30 * hank_hours + 14 * peggy_hours <= 118, "c14")
model.addConstr(30 * hank_hours + 25 * laura_hours <= 230, "c15")
model.addConstr(14 * bobby_hours + 14 * peggy_hours <= 111, "c16")
model.addConstr(25 * laura_hours + 14 * peggy_hours <= 201, "c17")
model.addConstr(30 * hank_hours + 8 * paul_hours <= 444, "c18")
model.addConstr(30 * hank_hours + 14 * bobby_hours + 25 * laura_hours + 8 * paul_hours + 14 * peggy_hours <= 444, "c19")  # Corrected: Added Peggy
model.addConstr(24 * paul_hours + 9 * peggy_hours <= 128, "c20")
model.addConstr(3 * hank_hours + 9 * peggy_hours <= 76, "c21")
model.addConstr(3 * hank_hours + 24 * paul_hours <= 110, "c22")
model.addConstr(3 * hank_hours + 18 * bobby_hours <= 47, "c23")
model.addConstr(3 * hank_hours + 20 * laura_hours <= 137, "c24")
model.addConstr(3 * hank_hours + 18 * bobby_hours + 20 * laura_hours <= 97, "c25")
model.addConstr(18 * bobby_hours + 20 * laura_hours + 9 * peggy_hours <= 162, "c26")
model.addConstr(3 * hank_hours + 24 * paul_hours + 9 * peggy_hours <= 47, "c27")
model.addConstr(3 * hank_hours + 18 * bobby_hours + 24 * paul_hours <= 201, "c28")
model.addConstr(3 * hank_hours + 20 * laura_hours + 9 * peggy_hours <= 181, "c29")
model.addConstr(18 * bobby_hours + 20 * laura_hours + 24 * paul_hours <= 103, "c30")
model.addConstr(3 * hank_hours + 18 * bobby_hours + 20 * laura_hours + 24 * paul_hours + 9 * peggy_hours <= 103, "c31")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")

