
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    HH = model.addVar(name="HH", vtype=gurobi.GRB.INTEGER)  # hours worked by Hank
    HB = model.addVar(name="HB", vtype=gurobi.GRB.INTEGER)  # hours worked by Bobby
    HL = model.addVar(name="HL", vtype=gurobi.GRB.INTEGER)  # hours worked by Laura
    HP = model.addVar(name="HP", vtype=gurobi.GRB.INTEGER)  # hours worked by Paul
    HPe = model.addVar(name="HPe")  # hours worked by Peggy

    # Objective function
    model.setObjective(2.55 * HH + 7.28 * HB + 5.19 * HL + 8.05 * HP + 9.52 * HPe, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(30 * HH <= 482)
    model.addConstr(3 * HH <= 202)
    model.addConstr(14 * HB <= 482)
    model.addConstr(18 * HB <= 202)
    model.addConstr(25 * HL <= 482)
    model.addConstr(20 * HL <= 202)
    model.addConstr(8 * HP <= 482)
    model.addConstr(24 * HP <= 202)
    model.addConstr(14 * HPe <= 482)
    model.addConstr(9 * HPe <= 202)

    model.addConstr(25 * HL + 8 * HP >= 59)
    model.addConstr(30 * HH + 25 * HL >= 92)
    model.addConstr(14 * HB + 25 * HL >= 57)
    model.addConstr(14 * HB + 14 * HPe >= 54)
    model.addConstr(14 * HB + 8 * HP >= 74)
    model.addConstr(30 * HH + 14 * HB + 8 * HP >= 58)
    model.addConstr(14 * HB + 25 * HL + 14 * HPe >= 58)
    model.addConstr(30 * HH + 14 * HB + 8 * HP >= 51)
    model.addConstr(14 * HB + 25 * HL + 14 * HPe >= 51)

    model.addConstr(20 * HL + 24 * HP + 9 * HPe >= 25)
    model.addConstr(18 * HB + 20 * HL + 24 * HP >= 25)
    model.addConstr(20 * HL + 24 * HP + 9 * HPe >= 29)
    model.addConstr(18 * HB + 20 * HL + 24 * HP >= 29)

    model.addConstr(30 * HH + 14 * HPe <= 118)
    model.addConstr(30 * HH + 25 * HL <= 230)
    model.addConstr(14 * HB + 14 * HPe <= 111)
    model.addConstr(25 * HL + 14 * HPe <= 201)
    model.addConstr(30 * HH + 8 * HP <= 444)
    model.addConstr(30 * HH + 14 * HB + 25 * HL + 8 * HP + 14 * HPe <= 444)

    model.addConstr(24 * HP + 9 * HPe <= 128)
    model.addConstr(3 * HH + 9 * HPe <= 76)
    model.addConstr(3 * HH + 24 * HP <= 110)
    model.addConstr(3 * HH + 18 * HB <= 47)
    model.addConstr(3 * HH + 20 * HL <= 137)
    model.addConstr(3 * HH + 18 * HB + 20 * HL <= 97)
    model.addConstr(18 * HB + 20 * HL + 9 * HPe <= 162)
    model.addConstr(3 * HH + 24 * HP + 9 * HPe <= 47)
    model.addConstr(3 * HH + 18 * HB + 24 * HP <= 201)
    model.addConstr(3 * HH + 20 * HL + 9 * HPe <= 181)
    model.addConstr(18 * HB + 20 * HL + 24 * HP <= 103)
    model.addConstr(3 * HH + 18 * HB + 20 * HL + 24 * HP + 9 * HPe <= 103)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("HH: ", HH.varValue)
        print("HB: ", HB.varValue)
        print("HL: ", HL.varValue)
        print("HP: ", HP.varValue)
        print("HPe: ", HPe.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
