
import gurobipy as gp

# Create a new model
m = gp.Model("employee_scheduling")

# Create variables
hank_hours = m.addVar(vtype=gp.GRB.INTEGER, name="hank_hours")
bobby_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bobby_hours")
ringo_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="ringo_hours")

# Set objective function
m.setObjective(4 * hank_hours + 3 * bobby_hours + 1 * ringo_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(11 * hank_hours + 22 * ringo_hours >= 38, "paperwork_hank_ringo")
m.addConstr(11 * hank_hours + 7 * bobby_hours >= 67, "paperwork_hank_bobby")
m.addConstr(11 * hank_hours + 7 * bobby_hours + 22 * ringo_hours >= 67, "paperwork_all")

m.addConstr(18 * bobby_hours + 5 * ringo_hours >= 90, "organization_bobby_ringo")
m.addConstr(20 * hank_hours + 18 * bobby_hours >= 69, "organization_hank_bobby")
m.addConstr(20 * hank_hours + 18 * bobby_hours + 5 * ringo_hours >= 69, "organization_all")

m.addConstr(13 * hank_hours + 9 * ringo_hours >= 58, "computer_hank_ringo")
m.addConstr(13 * hank_hours + 16 * bobby_hours >= 25, "computer_hank_bobby")
m.addConstr(13 * hank_hours + 16 * bobby_hours + 9 * ringo_hours >= 25, "computer_all")

m.addConstr(20 * hank_hours + 5 * bobby_hours >= 44, "quit_hank_bobby")
m.addConstr(20 * hank_hours + 1 * ringo_hours >= 27, "quit_hank_ringo")
m.addConstr(5 * bobby_hours + 1 * ringo_hours >= 45, "quit_bobby_ringo")
m.addConstr(20 * hank_hours + 5 * bobby_hours + 1 * ringo_hours >= 45, "quit_all")

m.addConstr(10 * hank_hours - 10 * ringo_hours >= 0, "hank_ringo_relation")

m.addConstr(11 * hank_hours + 22 * ringo_hours <= 242, "paperwork_hank_ringo_upper")
m.addConstr(7 * bobby_hours + 22 * ringo_hours <= 96, "paperwork_bobby_ringo_upper")
m.addConstr(20 * hank_hours + 18 * bobby_hours + 5 * ringo_hours <= 278, "organization_all_upper")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Hank Hours: %g' % hank_hours.x)
    print('Bobby Hours: %g' % bobby_hours.x)
    print('Ringo Hours: %g' % ringo_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
