
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
Hank_hours = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Hank")
Bobby_hours = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")
Ringo_hours = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Ringo")

# Objective function
m.setObjective(4*Hank_hours + 3*Bobby_hours + Ringo_hours, GRB.MINIMIZE)

# Constraints
# Paperwork competence rating constraints
m.addConstr(11*Hank_hours + 22*Ringo_hours >= 38, name="paperwork_combined_HR")
m.addConstr(11*Hank_hours + 7*Bobby_hours >= 67, name="paperwork_combined_HB")
m.addConstr(11*Hank_hours + 7*Bobby_hours + 22*Ringo_hours >= 67, name="paperwork_combined_all")
m.addConstr(11*Hank_hours + 22*Ringo_hours <= 242, name="paperwork_upper_bound_HR")
m.addConstr(7*Bobby_hours + 22*Ringo_hours <= 96, name="paperwork_upper_bound_BR")

# Organization score constraints
m.addConstr(18*Bobby_hours + 5*Ringo_hours >= 90, name="organization_combined_BR")
m.addConstr(20*Hank_hours + 18*Bobby_hours >= 69, name="organization_combined_HB")
m.addConstr(20*Hank_hours + 18*Bobby_hours + 5*Ringo_hours >= 69, name="organization_lower_bound_all")
m.addConstr(20*Hank_hours + 18*Bobby_hours + 5*Ringo_hours <= 278, name="organization_upper_bound_all")

# Computer competence rating constraints
m.addConstr(13*Hank_hours + 9*Ringo_hours >= 58, name="computer_combined_HR")
m.addConstr(13*Hank_hours + 16*Bobby_hours >= 25, name="computer_combined_HB")
m.addConstr(13*Hank_hours + 16*Bobby_hours + 9*Ringo_hours >= 25, name="computer_lower_bound_all")

# Likelihood to quit index constraints
m.addConstr(20*Hank_hours + 5*Bobby_hours >= 44, name="quit_index_combined_HB")
m.addConstr(20*Hank_hours + Ringo_hours >= 27, name="quit_index_combined_HR")
m.addConstr(5*Bobby_hours + Ringo_hours >= 45, name="quit_index_combined_BR")
m.addConstr(20*Hank_hours + 5*Bobby_hours + Ringo_hours >= 45, name="quit_index_lower_bound_all")

# Additional constraints
m.addConstr(10*Hank_hours - 10*Ringo_hours >= 0, name="additional_constraint")

# Optimize model
m.optimize()
