
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    H = model.addVar(name="H", lb=0, type=gurobi.GRB.INTEGER)  # Integer hours worked by Hank
    B = model.addVar(name="B", lb=0)  # Continuous hours worked by Bobby
    R = model.addVar(name="R", lb=0)  # Continuous hours worked by Ringo

    # Define the objective function
    model.setObjective(4 * H + 3 * B + R, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(11 * H + 22 * R >= 38)
    model.addConstr(11 * H + 7 * B >= 67)
    model.addConstr(11 * H + 7 * B + 22 * R >= 67)
    model.addConstr(18 * B + 5 * R >= 90)
    model.addConstr(20 * H + 18 * B >= 69)
    model.addConstr(20 * H + 18 * B + 5 * R >= 69)
    model.addConstr(13 * H + 9 * R >= 58)
    model.addConstr(13 * H + 16 * B >= 25)
    model.addConstr(13 * H + 16 * B + 9 * R >= 25)
    model.addConstr(20 * H + 5 * B >= 44)
    model.addConstr(20 * H + R >= 27)
    model.addConstr(5 * B + R >= 45)
    model.addConstr(20 * H + 5 * B + R >= 45)
    model.addConstr(10 * H - 10 * R >= 0)
    model.addConstr(11 * H + 22 * R <= 242)
    model.addConstr(7 * B + 22 * R <= 96)
    model.addConstr(20 * H + 18 * B + 5 * R <= 278)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Hank: {H.varValue}")
        print(f"Hours worked by Bobby: {B.varValue}")
        print(f"Hours worked by Ringo: {R.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
