
import gurobipy as gp

# Create a new model
m = gp.Model("Resource Allocation")

# Define decision variables
x = m.addVars(6, vtype=gp.GRB.INTEGER, name=['air_defense', 'cbrn', 'armored', 'water', 'pathfinder', 'recon'])

# Set objective function
m.setObjective(8.74 * x[0] + 6.8 * x[1] + 1.88 * x[2] + 8.47 * x[3] + 4.5 * x[4] + 6.83 * x[5], gp.GRB.MAXIMIZE)

# Define defensive capability ratings
defensive_ratings = [5, 4, 8, 4, 12, 11]

# Constraint: Total defensive capability rating upper bound
m.addConstr(gp.quicksum(defensive_ratings[i] * x[i] for i in range(6)) <= 144, "total_defense_ub")


# Add other constraints as specified in the prompt.  Note the deduplication and simplification.
m.addConstr(5*x[0] + 12*x[4] >= 20)
m.addConstr(4*x[1] + 4*x[3] + 11*x[5] >= 23)
m.addConstr(4*x[3] + 12*x[4] + 11*x[5] >= 23)
m.addConstr(4*x[1] + 12*x[4] + 11*x[5] >= 23)
m.addConstr(5*x[0] + 8*x[2] + 11*x[5] >= 23)
m.addConstr(5*x[0] + 12*x[4] + 11*x[5] >= 23)
m.addConstr(4*x[1] + 8*x[2] + 12*x[4] >= 23)
m.addConstr(5*x[0] + 4*x[1] + 11*x[5] >= 23)
m.addConstr(5*x[0] + 8*x[2] + 4*x[3] >= 23)
m.addConstr(5*x[0] + 4*x[3] + 12*x[4] >= 23)
m.addConstr(5*x[0] + 4*x[1] + 12*x[4] >= 23)
m.addConstr(4*x[1] + 4*x[3] + 12*x[4] >= 23)
m.addConstr(4*x[1] + 8*x[2] + 11*x[5] >= 23)
m.addConstr(8*x[2] + 4*x[3] + 12*x[4] >= 23)
m.addConstr(4*x[1] + 8*x[2] + 4*x[3] >= 23)
m.addConstr(5*x[0] + 4*x[1] + 8*x[2] >= 23)

m.addConstr(8*x[2] + 4*x[3] <= 137)
m.addConstr(5*x[0] + 11*x[5] <= 110)
m.addConstr(4*x[3] + 12*x[4] <= 25)
m.addConstr(4*x[1] + 8*x[2] <= 117)
m.addConstr(8*x[2] + 11*x[5] <= 38)
m.addConstr(5*x[0] + 4*x[1] <= 112)
m.addConstr(8*x[2] + 12*x[4] <= 74)
m.addConstr(4*x[3] + 11*x[5] <= 32)
m.addConstr(5*x[0] + 12*x[4] <= 31)
m.addConstr(5*x[0] + 4*x[1] + 11*x[5] <= 114)
m.addConstr(4*x[1] + 4*x[3] + 12*x[4] <= 77)
m.addConstr(5*x[0] + 8*x[2] + 12*x[4] <= 90)
m.addConstr(5*x[0] + 4*x[1] + 8*x[2] + 4*x[3] + 12*x[4] + 11*x[5] <= 90)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

