
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x1 = m.addVar(name="air_defense_batteries", vtype=gp.GRB_INTEGER)
x2 = m.addVar(name="CBRN_platoons", vtype=gp.GRB_INTEGER)
x3 = m.addVar(name="armored_companies", vtype=gp.GRB_INTEGER)
x4 = m.addVar(name="water_purification_units", vtype=gp.GRB_INTEGER)
x5 = m.addVar(name="pathfinder_teams", vtype=gp.GRB_INTEGER)
x6 = m.addVar(name="reconnaissance_troops", vtype=gp.GRB_INTEGER)

# Objective function
m.setObjective(8.74 * x1 + 6.8 * x2 + 1.88 * x3 + 8.47 * x4 + 4.5 * x5 + 6.83 * x6, gp.GRB_MAXIMIZE)

# Constraints
m.addConstr(5 * x1 + 12 * x5 >= 20)
m.addConstr(4 * x2 + 4 * x4 + 11 * x6 >= 23)
m.addConstr(4 * x4 + 12 * x5 + 11 * x6 >= 23)
# Add other constraints here...

# Add upper bound constraints
m.addConstr(8 * x3 + 4 * x4 <= 137)
m.addConstr(5 * x1 + 11 * x6 <= 110)
m.addConstr(4 * x4 + 12 * x5 <= 25)
m.addConstr(8 * x3 + 4 * x2 <= 117)
m.addConstr(8 * x3 + 11 * x6 <= 38)
m.addConstr(8 * x1 + 4 * x2 <= 112)
m.addConstr(8 * x3 + 12 * x5 <= 74)
m.addConstr(4 * x4 + 11 * x6 <= 32)
m.addConstr(5 * x1 + 12 * x5 <= 31)
m.addConstr(8 * x1 + 4 * x2 + 11 * x6 <= 114)
m.addConstr(4 * x2 + 4 * x4 + 12 * x5 <= 77)
m.addConstr(8 * x1 + 8 * x3 + 12 * x5 <= 90)
m.addConstr(5 * x1 + 4 * x2 + 8 * x3 + 4 * x4 + 12 * x5 + 11 * x6 <= 90)

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB_OPTIMAL:
    print("Optimal solution found.")
    print("Air defense batteries:", x1.varValue)
    print("CBRN platoons:", x2.varValue)
    print("Armored companies:", x3.varValue)
    print("Water purification units:", x4.varValue)
    print("Pathfinder teams:", x5.varValue)
    print("Reconnaissance troops:", x6.varValue)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
