
import gurobipy as gp

# Create a new model
m = gp.Model("protein_optimization")

# Create variables
milkshakes = m.addVar(lb=0, name="milkshakes")
sandwiches = m.addVar(lb=0, name="peanutbutter_sandwiches")

# Set objective function
m.setObjective(1.66 * milkshakes + 8.63 * sandwiches, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8.76 * milkshakes + 11.41 * sandwiches >= 36, "protein_min")
m.addConstr(1 * milkshakes - 9 * sandwiches >= 0, "milkshake_sandwich_ratio")
m.addConstr(8.76 * milkshakes + 11.41 * sandwiches <= 58, "protein_max1")
m.addConstr(8.76 * milkshakes + 11.41 * sandwiches == 58, "protein_max2") # Note: protein_max1 and protein_max2 are equivalent to just protein_max2


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Number of milkshakes: {milkshakes.x}")
    print(f"Number of peanutbutter sandwiches: {sandwiches.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

