
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
milkshakes = m.addVar(lb=0, name="milkshakes", vtype=GRB.CONTINUOUS)
peanutbutter_sandwiches = m.addVar(lb=0, name="peanutbutter_sandwiches", vtype=GRB.CONTINUOUS)

# Define the objective function
m.setObjective(1.66 * milkshakes + 8.63 * peanutbutter_sandwiches, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8.76 * milkshakes + 11.41 * peanutbutter_sandwiches >= 36, name="protein_min")
m.addConstr(milkshakes - 9 * peanutbutter_sandwiches >= 0, name="milkshake_peanut_ratio")
m.addConstr(8.76 * milkshakes + 11.41 * peanutbutter_sandwiches <= 58, name="protein_max")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milkshakes: {milkshakes.x}")
    print(f"Peanut butter sandwiches: {peanutbutter_sandwiches.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
