
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    milkshakes = model.addVar(lb=0, name="milkshakes", vtype=gurobi.GRB.CONTINUOUS)
    peanutbutter_sandwiches = model.addVar(lb=0, name="peanutbutter_sandwiches", vtype=gurobi.GRB.CONTINUOUS)

    # Define coefficients for the objective function
    model.setObjective(1.66 * milkshakes + 8.63 * peanutbutter_sandwiches, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Total protein constraint: 36 <= 8.76*milkshakes + 11.41*peanutbutter_sandwiches <= 58
    model.addConstr(8.76 * milkshakes + 11.41 * peanutbutter_sandwiches >= 36, name="min_protein")
    model.addConstr(8.76 * milkshakes + 11.41 * peanutbutter_sandwiches <= 58, name="max_protein")

    # Specific constraint: milkshakes - 9 * peanutbutter_sandwiches >= 0
    model.addConstr(milkshakes - 9 * peanutbutter_sandwiches >= 0, name="specific_constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal value: {model.objVal}")
        print(f"Milkshakes: {milkshakes.x}")
        print(f"Peanutbutter sandwiches: {peanutbutter_sandwiches.x}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
