
import gurobipy as gp

# Create a new model
m = gp.Model("WorkHoursOptimization")

# Create variables
bobby_hours = m.addVar(vtype=gp.GRB.INTEGER, name="bobby_hours")
paul_hours = m.addVar(vtype=gp.GRB.INTEGER, name="paul_hours")
ringo_hours = m.addVar(vtype=gp.GRB.INTEGER, name="ringo_hours")

# Set objective function
m.setObjective(4 * bobby_hours + 5 * paul_hours + 3 * ringo_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * bobby_hours + 7 * ringo_hours >= 16, "dollar_cost_bobby_ringo_min")
m.addConstr(9 * paul_hours + 5 * ringo_hours >= 18, "likelihood_paul_ringo_min")
m.addConstr(4 * bobby_hours + 9 * paul_hours >= 12, "likelihood_bobby_paul_min")
m.addConstr(4 * bobby_hours + 9 * paul_hours + 5 * ringo_hours >= 15, "likelihood_all_min")
m.addConstr(5 * bobby_hours + 1 * paul_hours <= 45, "dollar_cost_bobby_paul_max")
m.addConstr(1 * paul_hours + 7 * ringo_hours <= 47, "dollar_cost_paul_ringo_max")
m.addConstr(5 * bobby_hours + 1 * paul_hours + 7 * ringo_hours <= 26, "dollar_cost_all_max")
m.addConstr(4 * bobby_hours + 9 * paul_hours <= 52, "likelihood_bobby_paul_max")
m.addConstr(9 * paul_hours + 5 * ringo_hours <= 37, "likelihood_paul_ringo_max")
m.addConstr(4 * bobby_hours + 9 * paul_hours + 5 * ringo_hours <= 37, "likelihood_all_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('Bobby hours:', bobby_hours.x)
    print('Paul hours:', paul_hours.x)
    print('Ringo hours:', ringo_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', m.status)

