
from gurobipy import *

# Create a model
m = Model("Work_Hours_Optimization")

# Define variables
B = m.addVar(vtype=GRB.INTEGER, name="Hours_worked_by_Bobby")
P = m.addVar(vtype=GRB.INTEGER, name="Hours_worked_by_Paul")
R = m.addVar(vtype=GRB.INTEGER, name="Hours_worked_by_Ringo")

# Objective function: Maximize 4B + 5P + 3R
m.setObjective(4*B + 5*P + 3*R, GRB.MAXIMIZE)

# Constraints
m.addConstr(5*B + 7*R >= 16, "Min_dollar_cost_B_R")
m.addConstr(9*P + 5*R >= 18, "Min_quit_index_P_R")
m.addConstr(4*B + 9*P >= 12, "Min_quit_index_B_P")
m.addConstr(4*B + 9*P + 5*R >= 15, "Min_total_quit_index")
m.addConstr(5*B + 1*P <= 45, "Max_dollar_cost_B_P")
m.addConstr(1*P + 7*R <= 47, "Max_dollar_cost_P_R")
m.addConstr(5*B + 1*P + 7*R <= 26, "Max_total_dollar_cost")
m.addConstr(4*B + 9*P <= 52, "Max_quit_index_B_P")
m.addConstr(9*P + 5*R <= 37, "Max_quit_index_P_R")
m.addConstr(4*B + 9*P + 5*R <= 37, "Max_total_quit_index")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bobby works {B.x} hours")
    print(f"Paul works {P.x} hours")
    print(f"Ringo works {R.x} hours")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found")
