
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    bobby_hours = model.addVar(name="bobby_hours", vtype=gurobi.GRB.INTEGER)
    paul_hours = model.addVar(name="paul_hours", vtype=gurobi.GRB.INTEGER)
    ringo_hours = model.addVar(name="ringo_hours", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(4 * bobby_hours + 5 * paul_hours + 3 * ringo_hours, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5 * bobby_hours + 7 * ringo_hours >= 16, name="cost_constraint")
    model.addConstr(9 * paul_hours + 5 * ringo_hours >= 18, name="quit_index_constraint_paul_ringo")
    model.addConstr(4 * bobby_hours + 9 * paul_hours >= 12, name="quit_index_constraint_bobby_paul")
    model.addConstr(4 * bobby_hours + 9 * paul_hours + 5 * ringo_hours >= 15, name="quit_index_constraint_all")
    model.addConstr(5 * bobby_hours + paul_hours <= 45, name="cost_constraint_bobby_paul")
    model.addConstr(paul_hours + 7 * ringo_hours <= 47, name="cost_constraint_paul_ringo")
    model.addConstr(5 * bobby_hours + paul_hours + 7 * ringo_hours <= 26, name="cost_constraint_all")
    model.addConstr(4 * bobby_hours + 9 * paul_hours <= 52, name="quit_index_constraint_bobby_paul_max")
    model.addConstr(9 * paul_hours + 5 * ringo_hours <= 37, name="quit_index_constraint_paul_ringo_max")
    model.addConstr(4 * bobby_hours + 9 * paul_hours + 5 * ringo_hours <= 37, name="quit_index_constraint_all_max")

    # Update the model
    model.update()

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bobby hours: {bobby_hours.varValue}")
        print(f"Paul hours: {paul_hours.varValue}")
        print(f"Ringo hours: {ringo_hours.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
