
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")
fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")
vitamin_b6 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b6")
vitamin_b5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")

# Set objective function
m.setObjective(5.19 * vitamin_a + 8.36 * fat + 4.74 * vitamin_b6 + 3.83 * vitamin_b5, gp.GRB.MAXIMIZE)

# Add resource constraints
resources = {
    'r0': {'description': 'kidney support index', 'upper_bound': 75, 'x0': 12, 'x1': 12, 'x2': 13, 'x3': 4},
    'r1': {'description': 'immune support index', 'upper_bound': 221, 'x0': 10, 'x1': 9, 'x2': 9, 'x3': 14},
    'r2': {'description': 'cognitive performance index', 'upper_bound': 166, 'x0': 2, 'x1': 8, 'x2': 4, 'x3': 11}
}

for r_key, r_data in resources.items():
    m.addConstr(r_data['x0'] * vitamin_a + r_data['x1'] * fat + r_data['x2'] * vitamin_b6 + r_data['x3'] * vitamin_b5 <= r_data['upper_bound'], name=r_key)


# Add additional constraints as specified in the prompt
m.addConstr(12 * vitamin_a + 4 * vitamin_b5 >= 13)
m.addConstr(12 * vitamin_a + 12 * fat + 4 * vitamin_b5 >= 15)
m.addConstr(12 * fat + 13 * vitamin_b6 + 4 * vitamin_b5 >= 15)
m.addConstr(12 * vitamin_a + 12 * fat + 4 * vitamin_b5 >= 11)
m.addConstr(12 * fat + 13 * vitamin_b6 + 4 * vitamin_b5 >= 11)
m.addConstr(10 * vitamin_a + 9 * vitamin_b6 >= 28)
m.addConstr(10 * vitamin_a + 14 * vitamin_b5 >= 33)
m.addConstr(10 * vitamin_a + 9 * vitamin_b6 + 14 * vitamin_b5 >= 44)
m.addConstr(9 * fat + 9 * vitamin_b6 + 14 * vitamin_b5 >= 44)
m.addConstr(10 * vitamin_a + 9 * vitamin_b6 + 14 * vitamin_b5 >= 35)
m.addConstr(9 * fat + 9 * vitamin_b6 + 14 * vitamin_b5 >= 35)
m.addConstr(4 * vitamin_b6 + 11 * vitamin_b5 >= 28)
m.addConstr(2 * vitamin_a + 11 * vitamin_b5 >= 30)
m.addConstr(2 * vitamin_a + 8 * fat >= 26)
m.addConstr(8 * fat + 4 * vitamin_b6 >= 30)
m.addConstr(8 * fat + 4 * vitamin_b6 + 11 * vitamin_b5 >= 38)
m.addConstr(12 * vitamin_a + 12 * fat <= 63)
m.addConstr(12 * fat + 13 * vitamin_b6 <= 59)
m.addConstr(12 * vitamin_a + 12 * fat + 13 * vitamin_b6 <= 62)
m.addConstr(12 * vitamin_a + 12 * fat + 4 * vitamin_b5 <= 57)
m.addConstr(12 * fat + 13 * vitamin_b6 + 4 * vitamin_b5 <= 45)
m.addConstr(12 * vitamin_a + 12 * fat + 13 * vitamin_b6 + 4 * vitamin_b5 <= 45)
m.addConstr(10 * vitamin_a + 14 * vitamin_b5 <= 193)
m.addConstr(10 * vitamin_a + 9 * vitamin_b6 <= 183)
m.addConstr(10 * vitamin_a + 9 * fat <= 162)
m.addConstr(9 * fat + 9 * vitamin_b6 <= 118)
m.addConstr(10 * vitamin_a + 9 * vitamin_b6 + 14 * vitamin_b5 <= 196)
m.addConstr(10 * vitamin_a + 9 * fat + 9 * vitamin_b6 + 14 * vitamin_b5 <= 196)
m.addConstr(2 * vitamin_a + 11 * vitamin_b5 <= 65)
m.addConstr(8 * fat + 4 * vitamin_b6 <= 58)
m.addConstr(2 * vitamin_a + 8 * fat <= 77)
m.addConstr(2 * vitamin_a + 8 * fat + 4 * vitamin_b6 + 11 * vitamin_b5 <= 77)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

