
import gurobi

def optimize():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=0, name="milligrams of vitamin A")
    x1 = model.addVar(lb=0, name="grams of fat")
    x2 = model.addVar(lb=0, name="milligrams of vitamin B6")
    x3 = model.addVar(lb=0, name="milligrams of vitamin B5")

    # Objective function
    model.setObjective(5.19*x0 + 8.36*x1 + 4.74*x2 + 3.83*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(12*x0 <= 75)
    model.addConstr(10*x0 <= 221)
    model.addConstr(2*x0 <= 166)
    model.addConstr(12*x1 <= 75)
    model.addConstr(9*x1 <= 221)
    model.addConstr(8*x1 <= 166)
    model.addConstr(13*x2 <= 75)
    model.addConstr(9*x2 <= 221)
    model.addConstr(4*x2 <= 166)
    model.addConstr(4*x3 <= 75)
    model.addConstr(14*x3 <= 221)
    model.addConstr(11*x3 <= 166)

    model.addConstr(12*x0 + 4*x3 >= 13)
    model.addConstr(12*x0 + 12*x1 + 4*x3 >= 15)
    model.addConstr(12*x1 + 13*x2 + 4*x3 >= 15)
    model.addConstr(12*x0 + 12*x1 + 4*x3 >= 11)
    model.addConstr(12*x1 + 13*x2 + 4*x3 >= 11)

    model.addConstr(10*x0 + 9*x2 >= 28)
    model.addConstr(10*x0 + 14*x3 >= 33)
    model.addConstr(10*x0 + 9*x2 + 14*x3 >= 44)
    model.addConstr(9*x1 + 9*x2 + 14*x3 >= 44)
    model.addConstr(10*x0 + 9*x2 + 14*x3 >= 35)
    model.addConstr(9*x1 + 9*x2 + 14*x3 >= 35)

    model.addConstr(4*x2 + 11*x3 >= 28)
    model.addConstr(2*x0 + 11*x3 >= 30)
    model.addConstr(2*x0 + 8*x1 >= 26)
    model.addConstr(8*x1 + 4*x2 >= 30)
    model.addConstr(8*x1 + 4*x2 + 11*x3 >= 38)

    model.addConstr(12*x0 + 12*x1 <= 63)
    model.addConstr(12*x1 + 13*x2 <= 59)
    model.addConstr(12*x0 + 12*x1 + 13*x2 <= 62)
    model.addConstr(12*x0 + 12*x1 + 4*x3 <= 57)
    model.addConstr(12*x1 + 13*x2 + 4*x3 <= 45)
    model.addConstr(12*x0 + 12*x1 + 13*x2 + 4*x3 <= 45)

    model.addConstr(10*x0 + 14*x3 <= 193)
    model.addConstr(10*x0 + 9*x2 <= 183)
    model.addConstr(10*x0 + 9*x1 <= 162)
    model.addConstr(9*x1 + 9*x2 <= 118)
    model.addConstr(10*x0 + 9*x2 + 14*x3 <= 196)
    model.addConstr(10*x0 + 9*x1 + 9*x2 + 14*x3 <= 196)

    model.addConstr(2*x0 + 11*x3 <= 65)
    model.addConstr(8*x1 + 4*x2 <= 58)
    model.addConstr(2*x0 + 8*x1 <= 77)
    model.addConstr(2*x0 + 8*x1 + 4*x2 + 11*x3 <= 77)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("Milligrams of vitamin A: ", x0.varValue)
        print("Grams of fat: ", x1.varValue)
        print("Milligrams of vitamin B6: ", x2.varValue)
        print("Milligrams of vitamin B5: ", x3.varValue)
        print("Objective function value: ", model.objVal)
    else:
        print("No optimal solution found.")

optimize()
