
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Work_Optimization")

# Create variables
ringo = m.addVar(vtype=GRB.INTEGER, name="ringo")
paul = m.addVar(vtype=GRB.INTEGER, name="paul")
peggy = m.addVar(vtype=GRB.INTEGER, name="peggy")
george = m.addVar(vtype=GRB.INTEGER, name="george")
laura = m.addVar(vtype=GRB.INTEGER, name="laura")
bobby = m.addVar(vtype=GRB.INTEGER, name="bobby")
mary = m.addVar(vtype=GRB.INTEGER, name="mary")


# Set objective function
m.setObjective(4 * ringo + 9 * paul + 8 * peggy + 6 * george + laura + 6 * bobby + 2 * mary, GRB.MAXIMIZE)

# Resource data
resources = {'r0': {'description': 'paperwork competence rating', 'upper_bound': 319, 'x0': 19, 'x1': 31, 'x2': 30, 'x3': 30, 'x4': 11, 'x5': 6, 'x6': 15}, 'r1': {'description': 'likelihood to quit index', 'upper_bound': 589, 'x0': 7, 'x1': 34, 'x2': 28, 'x3': 2, 'x4': 19, 'x5': 1, 'x6': 18}, 'r2': {'description': 'computer competence rating', 'upper_bound': 368, 'x0': 1, 'x1': 5, 'x2': 12, 'x3': 24, 'x4': 32, 'x5': 21, 'x6': 34}}
variables = [ringo, paul, peggy, george, laura, bobby, mary]
resource_constraints = []

# Resource constraints
for resource, data in resources.items():
    expr = gp.LinExpr()
    for i, var in enumerate(variables):
        expr += data[f'x{i}'] * var
    resource_constraints.append(m.addConstr(expr <= data['upper_bound'], resource))


# Additional constraints (simplified and deduplicated)
m.addConstr(19*ringo + 6*bobby >= 37)
m.addConstr(11*laura + 6*bobby >= 25)
m.addConstr(31*paul + 11*laura >= 22)

for rhs in [29, 30, 31, 32, 34, 35, 36, 38, 40, 41, 43, 24, 27, 28]:
    m.addConstr(19*ringo + 30*george + 15*mary >= rhs)
    m.addConstr(19*ringo + 11*laura + 15*mary >= rhs)
    m.addConstr(30*peggy + 30*george + 11*laura >= rhs)
    m.addConstr(19*ringo + 30*peggy + 11*laura >= rhs)
    m.addConstr(19*ringo + 30*peggy + 30*george >= rhs)
    m.addConstr(19*ringo + 6*bobby + 15*mary >= rhs)
    m.addConstr(30*peggy + 30*george + 15*mary >= rhs)
    m.addConstr(19*ringo + 31*paul + 11*laura >= rhs)
    m.addConstr(31*paul + 30*george + 15*mary >= rhs)
    m.addConstr(31*paul + 11*laura + 6*bobby >= rhs)
    m.addConstr(19*ringo + 31*paul + 6*bobby >= rhs)
    m.addConstr(19*ringo + 31*paul + 30*peggy >= rhs)
    m.addConstr(19*ringo + 30*peggy + 15*mary >= rhs)
    m.addConstr(30*peggy + 6*bobby + 15*mary >= rhs)
    m.addConstr(31*paul + 30*peggy + 30*george >= rhs)
    m.addConstr(30*george + 11*laura + 6*bobby >= rhs)
    m.addConstr(30*peggy + 11*laura + 6*bobby >= rhs)
    m.addConstr(31*paul + 30*george + 6*bobby >= rhs)
    m.addConstr(19*ringo + 11*laura + 6*bobby >= rhs)
    m.addConstr(11*laura + 6*bobby + 15*mary >= rhs)
    m.addConstr(19*ringo + 31*paul + 30*george >= rhs)
    m.addConstr(19*ringo + 31*paul + 15*mary >= rhs)
    m.addConstr(31*paul + 30*peggy + 15*mary >= rhs)
    m.addConstr(31*paul + 30*george + 11*laura >= rhs)
    m.addConstr(30*peggy + 11*laura + 15*mary >= rhs)
    m.addConstr(30*george + 11*laura + 15*mary >= rhs)
    m.addConstr(31*paul + 6*bobby + 15*mary >= rhs)


for rhs in [49, 56, 57, 58, 60, 63, 67, 70, 73, 74, 78, 79, 81, 82, 43, 47, 48]:
    m.addConstr(7*ringo + 28*peggy + 2*george >= rhs)
    m.addConstr(7*ringo + 34*paul + 19*laura >= rhs)
    m.addConstr(7*ringo + 28*peggy + 18*mary >= rhs)
    m.addConstr(34*paul + bobby + 18*mary >= rhs)
    m.addConstr(34*paul + 28*peggy + 2*george >= rhs)
    m.addConstr(7*ringo + 34*paul + bobby >= rhs)
    m.addConstr(2*george + 19*laura + bobby >= rhs)
    m.addConstr(2*george + bobby + 18*mary >= rhs)
    m.addConstr(19*laura + bobby + 18*mary >= rhs)
    m.addConstr(28*peggy + 19*laura + bobby >= rhs)
    m.addConstr(28*peggy + 2*george + bobby >= rhs)
    m.addConstr(34*paul + 2*george + bobby >= rhs)
    m.addConstr(7*ringo + 19*laura + 18*mary >= rhs)
    m.addConstr(7*ringo + 2*george + bobby >= rhs)
    m.addConstr(7*ringo + 2*george + 19*laura >= rhs)
    m.addConstr(7*ringo + 34*paul + 2*george >= rhs)
    m.addConstr(34*paul + 2*george + 19*laura >= rhs)
    m.addConstr(34*paul + 2*george + 18*mary >= rhs)
    m.addConstr(7*ringo + 19*laura + bobby >= rhs)
    m.addConstr(34*paul + 19*laura + 18*mary >= rhs)
    m.addConstr(28*peggy + 19*laura + 18*mary >= rhs)

m.addConstr(5*paul + 24*george >= 34)
m.addConstr(ringo + 12*peggy >= 25)
m.addConstr(5*paul + 24*george + 32*laura >= 49)
m.addConstr(-8*ringo + 8*paul >= 0)
m.addConstr(30*peggy + 15*mary <= 96)
m.addConstr(19*ringo + 30*george <= 311)
m.addConstr(31*paul + 11*laura <= 73)
m.addConstr(30*george + 11*laura + 15*mary <= 47)
m.addConstr(19*ringo + 30*peggy + 6*bobby <= 248)
m.addConstr(19*ringo + 30*george + 11*laura <= 143)
m.addConstr(19*ringo + 31*paul + 15*mary <= 137)
m.addConstr(19*ringo + 31*paul + 30*peggy + 30*george + 11*laura + 6*bobby + 15*mary <= 137)
m.addConstr(28*peggy + 18*mary <= 475)
m.addConstr(7*ringo + 28*peggy <= 247)
m.addConstr(7*ringo + 34*paul <= 137)
m.addConstr(19*laura + 18*mary <= 148)
m.addConstr(34*paul + 18*mary <= 222)
m.addConstr(34*paul + bobby <= 525)
m.addConstr(2*george + 18*mary <= 402)
m.addConstr(7*ringo + 2*george <= 555)
m.addConstr(19*laura + bobby <= 324)
m.addConstr(7*ringo + 18*mary <= 476)
m.addConstr(bobby + 18*mary <= 477)
m.addConstr(7*ringo + bobby + 18*mary <= 410)
m.addConstr(7*ringo + 28*peggy + bobby <= 327)
m.addConstr(7*ringo + 34*paul + 19*laura <= 94)
m.addConstr(2*george + 19*laura + bobby <= 214)
m.addConstr(28*peggy + 2*george + 18*mary <= 246)
m.addConstr(28*peggy + 19*laura + 18*mary <= 550)
m.addConstr(34*paul + 28*peggy + 19*laura <= 535)
m.addConstr(7*ringo + 34*paul + 28*peggy <= 342)
m.addConstr(7*ringo + 28*peggy + 19*laura <= 410)
m.addConstr(7*ringo + 34*paul + 2*george <= 381)
m.addConstr(34*paul + 19*laura + bobby <= 157)
m.addConstr(2*george + 19*laura + 18*mary <= 339)
m.addConstr(19*laura + bobby + 18*mary <= 152)
m.addConstr(7*ringo + 2*george + 18*mary <= 162)
m.addConstr(7*ringo + 19*laura + bobby <= 353)
m.addConstr(34*paul + 28*peggy + 18*mary <= 339)
m.addConstr(34*paul + 28*peggy + 2*george <= 535)
m.addConstr(7*ringo + 28*peggy + 18*mary <= 188)
m.addConstr(7*ringo + 34*paul + 18*mary <= 389)
m.addConstr(28*peggy + 19*laura + bobby <= 462)
m.addConstr(7*ringo + 19*laura + 18*mary <= 149)
m.addConstr(7*ringo + 34*paul + 28*peggy + 2*george + 19*laura + bobby + 18*mary <= 149)
m.addConstr(21*bobby + 34*mary <= 295)
m.addConstr(5*paul + 24*george <= 271)
m.addConstr(5*paul + 21*bobby <= 284)
m.addConstr(ringo + 34*mary <= 229)
m.addConstr(ringo + 5*paul <= 127)
m.addConstr(ringo + 32*laura <= 226)
m.addConstr(24*george + 32*laura <= 201)
m.addConstr(24*george + 21*bobby <= 139)
m.addConstr(12*peggy + 24*george <= 143)
m.addConstr(12*peggy + 32*laura <= 287)
m.addConstr(12*peggy + 21*bobby <= 354)
m.addConstr(12*peggy + 34*mary <= 152)
m.addConstr(ringo + 24*george <= 173)
m.addConstr(5*paul + 34*mary <= 362)
m.addConstr(12*peggy + 24*george + 34*mary <= 292)
m.addConstr(ringo + 5*paul + 32*laura <= 234)
m.addConstr(24*george + 21*bobby + 34*mary <= 307)
m.addConstr(12*peggy + 21*bobby + 34*mary <= 54)
m.addConstr(ringo + 5*paul + 24*george <= 63)
m.addConstr(12*peggy + 32*laura + 34*mary <= 330)
m.addConstr(5*paul + 12*peggy + 21*bobby <= 277)
m.addConstr(12*peggy + 32*laura + 21*bobby <= 304)
m.addConstr(5*paul + 24*george + 32*laura <= 72)
m.addConstr(ringo + 12*peggy + 21*bobby <= 289)
m.addConstr(5*paul + 24*george + 21*bobby <= 187)
m.addConstr(ringo + 24*george + 32*laura <= 302)
m.addConstr(5*paul + 24*george + 34*mary <= 160)
m.addConstr(5*paul + 12*peggy + 34*mary <= 94)
m.addConstr(ringo + 5*paul + 34*mary <= 289)
m.addConstr(5*paul + 12*peggy + 32*laura <= 266)
m.addConstr(12*peggy + 24*george + 32*laura <= 60)
m.addConstr(ringo + 5*paul + 12*peggy + 24*george + 32*laura + 21*bobby + 34*mary <= 60)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization was stopped with status %d' % m.status)
    # Model is infeasible - compute IIS
    m.computeIIS()
    m.write("model.ilp")
    print('\nThe following constraint(s) cannot be satisfied:')
    for c in m.getConstrs():
        if c.IISConstr:
            print('%s' % c.constrName)
else:
    print('Optimization was stopped with status %d' % m.status)

