
import gurobi as gp

# Define the variables
hours_worked_by_Ringo = gp.Var(name='hours_worked_by_Ringo', lb=0)
hours_worked_by_Paul = gp.Var(name='hours_worked_by_Paul', lb=0, type=gp.GRB.INTEGER)
hours_worked_by_Peggy = gp.Var(name='hours_worked_by_Peggy', lb=0, type=gp.GRB.INTEGER)
hours_worked_by_George = gp.Var(name='hours_worked_by_George', lb=0, type=gp.GRB.INTEGER)
hours_worked_by_Laura = gp.Var(name='hours_worked_by_Laura', lb=0, type=gp.GRB.INTEGER)
hours_worked_by_Bobby = gp.Var(name='hours_worked_by_Bobby', lb=0, type=gp.GRB.INTEGER)
hours_worked_by_Mary = gp.Var(name='hours_worked_by_Mary', lb=0, type=gp.GRB.INTEGER)

# Define the model
m = gp.Model()

# Add variables to the model
m.addVar(hours_worked_by_Ringo)
m.addVar(hours_worked_by_Paul)
m.addVar(hours_worked_by_Peggy)
m.addVar(hours_worked_by_George)
m.addVar(hours_worked_by_Laura)
m.addVar(hours_worked_by_Bobby)
m.addVar(hours_worked_by_Mary)

# Define the objective function
m.setObjective(4 * hours_worked_by_Ringo + 9 * hours_worked_by_Paul + 8 * hours_worked_by_Peggy + 
               6 * hours_worked_by_George + hours_worked_by_Laura + 6 * hours_worked_by_Bobby + 
               2 * hours_worked_by_Mary, gp.GRB.MAXIMIZE)

# Add constraints
# Ringo constraints
m.addConstr(19 * hours_worked_by_Ringo <= 319)
m.addConstr(7 * hours_worked_by_Ringo <= 589)
m.addConstr(1 * hours_worked_by_Ringo <= 368)

# Paul constraints
m.addConstr(31 * hours_worked_by_Paul <= 319)
m.addConstr(34 * hours_worked_by_Paul <= 589)
m.addConstr(5 * hours_worked_by_Paul <= 368)

# Peggy constraints
m.addConstr(30 * hours_worked_by_Peggy <= 319)
m.addConstr(28 * hours_worked_by_Peggy <= 589)
m.addConstr(12 * hours_worked_by_Peggy <= 368)

# George constraints
m.addConstr(30 * hours_worked_by_George <= 319)
m.addConstr(2 * hours_worked_by_George <= 589)
m.addConstr(24 * hours_worked_by_George <= 368)

# Laura constraints
m.addConstr(11 * hours_worked_by_Laura <= 319)
m.addConstr(19 * hours_worked_by_Laura <= 589)
m.addConstr(32 * hours_worked_by_Laura <= 368)

# Bobby constraints
m.addConstr(6 * hours_worked_by_Bobby <= 319)
m.addConstr(1 * hours_worked_by_Bobby <= 589)
m.addConstr(21 * hours_worked_by_Bobby <= 368)

# Mary constraints
m.addConstr(15 * hours_worked_by_Mary <= 319)
m.addConstr(18 * hours_worked_by_Mary <= 589)
m.addConstr(34 * hours_worked_by_Mary <= 368)

# Paperwork constraints
# The total combined paperwork competence rating from hours worked by Ringo plus hours worked by Bobby should be equal to or greater than 37.
m.addConstr(19 * hours_worked_by_Ringo + 6 * hours_worked_by_Bobby >= 37)

# ... (rest of the constraints)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Hours worked by Ringo: ", hours_worked_by_Ringo.varValue)
    print("Hours worked by Paul: ", hours_worked_by_Paul.varValue)
    print("Hours worked by Peggy: ", hours_worked_by_Peggy.varValue)
    print("Hours worked by George: ", hours_worked_by_George.varValue)
    print("Hours worked by Laura: ", hours_worked_by_Laura.varValue)
    print("Hours worked by Bobby: ", hours_worked_by_Bobby.varValue)
    print("Hours worked by Mary: ", hours_worked_by_Mary.varValue)
else:
    print("The model is infeasible")
