
import gurobi as gp

def main():
    # Define the variables
    x0 = gp.Var(name="rotisserie_chickens", lb=0)
    x1 = gp.Var(name="chicken_breasts", lb=0)
    x2 = gp.Var(name="sashimi", lb=0)
    x3 = gp.Var(name="chicken_thighs", lb=0)
    x4 = gp.Var(name="strips_of_bacon", lb=0)
    x5 = gp.Var(name="oreos", lb=0)

    # Define the model
    m = gp.Model()

    # Objective function
    m.setObjective(4*x0*x1 + 6*x0*x2 + 9*x0*x3 + 9*x0*x4 + 7*x0*x5 + x1*x2 + 6*x1*x3 + 5*x1*x4 + 2*x1*x5 + x2**2 + 3*x2*x3 + 7*x2*x4 + 8*x2*x5 + 9*x3*x4 + 5*x4**2 + 6*x4*x5 + 8*x5**2 + 3*x0 + 2*x2 + 2*x3 + 7*x4 + 7*x5, gp.GRB.MINIMIZE)

    # Constraints
    m.addConstr(15*x0 + 17*x1 + 5*x2 + 6*x3 + 9*x4 + 8*x5 <= 607) # calcium
    m.addConstr(6*x0 + 27*x1 + 8*x2 + 1*x3 + 22*x4 + 23*x5 <= 360) # healthiness rating
    m.addConstr(26*x0 + 8*x1 + 9*x2 + 2*x3 + 8*x4 + 5*x5 <= 292) # umami index
    m.addConstr(1*x0 + 6*x1 + 3*x2 + 8*x3 + 9*x4 + 23*x5 <= 286) # iron
    m.addConstr(29*x0 + 25*x1 + 11*x2 + 22*x3 + 17*x4 + 18*x5 <= 405) # fat

    # Solve the problem
    m.optimize()

    # Print the solution
    if m.status == gp.GRB.OPTIMAL:
        print("Objective: ", m.objVal)
        print("Rotisserie Chickens: ", x0.varValue)
        print("Chicken Breasts: ", x1.varValue)
        print("Sashimi: ", x2.varValue)
        print("Chicken Thighs: ", x3.varValue)
        print("Strips of Bacon: ", x4.varValue)
        print("Oreos: ", x5.varValue)
    else:
        print("No optimal solution found")

if __name__ == "__main__":
    main()
