
from gurobipy import Model, GRB

# Create a new model
model = Model("optimize_work_hours")

# Create variables
paul_hours = model.addVar(vtype=GRB.INTEGER, name="paul_hours")
ringo_hours = model.addVar(vtype=GRB.CONTINUOUS, name="ringo_hours")

# Set objective function
model.setObjective(8.09 * paul_hours + 3.83 * ringo_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(28 * paul_hours + 8 * ringo_hours >= 56, "paperwork_min")
model.addConstr(25 * paul_hours + 29 * ringo_hours >= 65, "productivity_min")
model.addConstr(5 * paul_hours + 5 * ringo_hours >= 28, "quit_index_min")
model.addConstr(3 * paul_hours + 16 * ringo_hours >= 51, "organization_min")

model.addConstr(-3 * paul_hours + 10 * ringo_hours >= 0, "custom_constraint")

model.addConstr(28 * paul_hours + 8 * ringo_hours <= 139, "paperwork_max")
model.addConstr(25 * paul_hours + 29 * ringo_hours <= 122, "productivity_max")
model.addConstr(5 * paul_hours + 5 * ringo_hours <= 147, "quit_index_max")
model.addConstr(3 * paul_hours + 16 * ringo_hours <= 205, "organization_max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Paul's hours: {paul_hours.x}")
    print(f"  Ringo's hours: {ringo_hours.x}")
    print(f"  Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

