
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Paul")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Ringo")

# Set objective function
m.setObjective(8.09*x0 + 3.83*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(28*x0 + 8*x1 >= 56, "min_paperwork")
m.addConstr(25*x0 + 29*x1 >= 65, "min_productivity")
m.addConstr(5*x0 + 5*x1 >= 28, "min_quit_index")
m.addConstr(3*x0 + 16*x1 >= 51, "min_organization")
m.addConstr(-3*x0 + 10*x1 >= 0, "linear_constraint")

m.addConstr(28*x0 + 8*x1 <= 139, "max_paperwork")
m.addConstr(25*x0 + 29*x1 <= 122, "max_productivity")
m.addConstr(5*x0 + 5*x1 <= 147, "max_quit_index")
m.addConstr(3*x0 + 16*x1 <= 205, "max_organization")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Paul: {x0.x}")
    print(f"Hours worked by Ringo: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
