
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
hours_worked_by_Paul = m.addVar(name="hours_worked_by_Paul", integer=True)
hours_worked_by_Ringo = m.addVar(name="hours_worked_by_Ringo")

# Define the objective function
m.setObjective(8.09 * hours_worked_by_Paul + 3.83 * hours_worked_by_Ringo, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(28 * hours_worked_by_Paul + 8 * hours_worked_by_Ringo >= 56, name="paperwork_competence_rating_min")
m.addConstr(28 * hours_worked_by_Paul + 8 * hours_worked_by_Ringo <= 139, name="paperwork_competence_rating_max")
m.addConstr(25 * hours_worked_by_Paul + 29 * hours_worked_by_Ringo >= 65, name="productivity_rating_min")
m.addConstr(25 * hours_worked_by_Paul + 29 * hours_worked_by_Ringo <= 122, name="productivity_rating_max")
m.addConstr(5 * hours_worked_by_Paul + 5 * hours_worked_by_Ringo >= 28, name="likelihood_to_quit_index_min")
m.addConstr(5 * hours_worked_by_Paul + 5 * hours_worked_by_Ringo <= 147, name="likelihood_to_quit_index_max")
m.addConstr(3 * hours_worked_by_Paul + 16 * hours_worked_by_Ringo >= 51, name="organization_score_min")
m.addConstr(3 * hours_worked_by_Paul + 16 * hours_worked_by_Ringo <= 205, name="organization_score_max")
m.addConstr(-3 * hours_worked_by_Paul + 10 * hours_worked_by_Ringo >= 0, name="additional_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Paul: {hours_worked_by_Paul.varValue}")
    print(f"Hours worked by Ringo: {hours_worked_by_Ringo.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
