
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
b4 = model.addVar(vtype=GRB.INTEGER, name="milligrams of vitamin B4")
c = model.addVar(vtype=GRB.CONTINUOUS, name="milligrams of vitamin C")

# Set objective function
model.setObjective(1 * b4 + 5 * c, GRB.MAXIMIZE)

# Add constraints
model.addConstr(1 * b4 + 6 * c >= 52, "muscle_growth_min")
model.addConstr(-1 * b4 + 1 * c >= 0, "b4_c_ratio")
model.addConstr(1 * b4 + 6 * c <= 111, "muscle_growth_max")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  milligrams of vitamin B4: {b4.x}")
    print(f"  milligrams of vitamin C: {c.x}")
    print(f"  Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

