
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_B4")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_C")

# Set the objective function
m.setObjective(1*x0 + 5*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1*x0 + 6*x1 >= 52, "muscle_growth_index_min")
m.addConstr(-x0 + x1 >= 0, "vitamin_balance")
m.addConstr(1*x0 + 6*x1 <= 111, "muscle_growth_index_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B4: {x0.x}")
    print(f"Milligrams of Vitamin C: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
