
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="milligrams_of_vitamin_B4", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="milligrams_of_vitamin_C")

    # Objective function: Maximize 1*x0 + 5*x1
    model.setObjective(x0 + 5*x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x0 + 6*x1 >= 52, name="min_muscle_growth_index")
    model.addConstr(-x0 + x1 >= 0, name="vitamin_B4_C_relationship")
    model.addConstr(x0 + 6*x1 <= 111, name="max_muscle_growth_index")

    # Set bounds
    model.addConstr(x0 >= 0, name="x0_lower_bound")
    model.addConstr(x1 >= 0, name="x1_lower_bound")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B4: {x0.varValue}")
        print(f"Milligrams of vitamin C: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
