
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
calcium = m.addVar(name="calcium")
carbs = m.addVar(name="carbs")
vitamin_b4 = m.addVar(name="vitamin_b4")

# Set objective function
m.setObjective(3.0 * calcium**2 + 9.58 * calcium * carbs + 7.74 * calcium * vitamin_b4 + 1.46 * carbs * vitamin_b4 + 8.91 * vitamin_b4**2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * calcium + 21 * carbs + 21 * vitamin_b4 <= 334, "r0") #cognitive performance index
m.addConstr(24 * calcium + 6 * carbs + 29 * vitamin_b4 <= 327, "r1") #cardiovascular support index
m.addConstr(17 * calcium + 20 * carbs + 23 * vitamin_b4 <= 156, "r2") #digestive support index
m.addConstr(14 * calcium + 25 * carbs + 25 * vitamin_b4 <= 213, "r3") #muscle growth index
m.addConstr(23 * calcium + 4 * carbs + 15 * vitamin_b4 <= 316, "r4") #energy stability index


m.addConstr(3 * calcium + 21 * vitamin_b4 >= 91, "c1")
m.addConstr(3 * calcium + 21 * carbs >= 86, "c2")
m.addConstr(17 * calcium + 20 * carbs + 23 * vitamin_b4 >= 41, "c3")
m.addConstr(14 * calcium**2 + 25 * carbs**2 >= 62, "c4")
m.addConstr(25 * carbs + 25 * vitamin_b4 >= 52, "c5")
m.addConstr(4 * carbs**2 + 15 * vitamin_b4**2 >= 88, "c6")
m.addConstr(23 * calcium + 4 * carbs + 15 * vitamin_b4 >= 55, "c7")
m.addConstr(3 * calcium + 21 * carbs <= 257, "c8")
m.addConstr(3 * calcium + 21 * vitamin_b4 <= 257, "c9")
m.addConstr(3 * calcium + 21 * carbs + 21 * vitamin_b4 <= 257, "c10")
m.addConstr(6 * carbs**2 + 29 * vitamin_b4**2 <= 214, "c11")
m.addConstr(24 * calcium**2 + 6 * carbs**2 <= 230, "c12")
m.addConstr(24 * calcium + 6 * carbs + 29 * vitamin_b4 <= 230, "c13")
m.addConstr(17 * calcium + 23 * vitamin_b4 <= 83, "c14")
m.addConstr(17 * calcium + 20 * carbs + 23 * vitamin_b4 <= 83, "c15")
m.addConstr(14 * calcium + 25 * carbs <= 76, "c16")
m.addConstr(25 * carbs + 25 * vitamin_b4 <= 158, "c17")
m.addConstr(14 * calcium**2 + 25 * vitamin_b4**2 <= 181, "c18")
m.addConstr(14 * calcium + 25 * carbs + 25 * vitamin_b4 <= 181, "c19")
m.addConstr(23 * calcium**2 + 15 * vitamin_b4**2 <= 163, "c20")
m.addConstr(23 * calcium + 4 * carbs <= 220, "c21")
m.addConstr(4 * carbs + 15 * vitamin_b4 <= 309, "c22")
m.addConstr(23 * calcium + 4 * carbs + 15 * vitamin_b4 <= 309, "c23")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('calcium:', calcium.x)
    print('carbs:', carbs.x)
    print('vitamin_b4:', vitamin_b4.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('The problem could not be solved to optimality.')

