
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="milligrams_of_calcium", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x1 = m.addVar(name="grams_of_carbohydrates", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x2 = m.addVar(name="milligrams_of_vitamin_B4", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Define the objective function
m.setObjective(3.0 * x0**2 + 9.58 * x0 * x1 + 7.74 * x0 * x2 + 1.46 * x1 * x2 + 8.91 * x2**2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * x0 <= 334)
m.addConstr(24 * x0 <= 327)
m.addConstr(17 * x0 <= 156)
m.addConstr(14 * x0 <= 213)
m.addConstr(23 * x0 <= 316)

m.addConstr(21 * x1 <= 334)
m.addConstr(6 * x1 <= 327)
m.addConstr(20 * x1 <= 156)
m.addConstr(25 * x1 <= 213)
m.addConstr(4 * x1 <= 316)

m.addConstr(21 * x2 <= 334)
m.addConstr(29 * x2 <= 327)
m.addConstr(23 * x2 <= 156)
m.addConstr(25 * x2 <= 213)
m.addConstr(15 * x2 <= 316)

m.addConstr(3 * x0 + 21 * x2 >= 91)
m.addConstr(3 * x0 + 21 * x1 >= 86)
m.addConstr(17 * x0 + 20 * x1 + 23 * x2 >= 41)
m.addConstr(14 * x0**2 + 25 * x1**2 >= 62)
m.addConstr(25 * x1 + 25 * x2 >= 52)
m.addConstr(4 * x1**2 + 15 * x2**2 >= 88)
m.addConstr(23 * x0 + 4 * x1 + 15 * x2 >= 55)

m.addConstr(3 * x0 + 21 * x1 <= 257)
m.addConstr(3 * x0 + 21 * x2 <= 257)
m.addConstr(3 * x0 + 21 * x1 + 21 * x2 <= 257)

m.addConstr(6 * x1**2 + 29 * x2**2 <= 214)
m.addConstr(24 * x0**2 + 6 * x1**2 <= 230)
m.addConstr(24 * x0 + 6 * x1 + 29 * x2 <= 230)

m.addConstr(17 * x0 + 23 * x2 <= 83)
m.addConstr(17 * x0 + 20 * x1 + 23 * x2 <= 83)

m.addConstr(14 * x0 + 25 * x1 <= 76)
m.addConstr(25 * x1 + 25 * x2 <= 158)
m.addConstr(14 * x0**2 + 25 * x2**2 <= 181)
m.addConstr(14 * x0 + 25 * x1 + 25 * x2 <= 181)

m.addConstr(23 * x0**2 + 15 * x2**2 <= 163)
m.addConstr(23 * x0 + 4 * x1 <= 220)
m.addConstr(4 * x1 + 15 * x2 <= 309)
m.addConstr(23 * x0 + 4 * x1 + 15 * x2 <= 309)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of calcium: {x0.varValue}")
    print(f"Grams of carbohydrates: {x1.varValue}")
    print(f"Milligrams of vitamin B4: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
