
import gurobipy as gp

# Create a new model
m = gp.Model("employee_scheduling")

# Create variables
laura_hours = m.addVar(lb=0, name="laura_hours")
dale_hours = m.addVar(lb=0, name="dale_hours")

# Set objective function
m.setObjective(6.13 * laura_hours + 3.02 * dale_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4.87 * laura_hours + 1.72 * dale_hours >= 41, "productivity_min")
m.addConstr(0.28 * laura_hours + 6.84 * dale_hours >= 18, "organization_min")
m.addConstr(6.33 * laura_hours + 4.33 * dale_hours >= 17, "paperwork_min")
m.addConstr(5.0 * laura_hours + 3.52 * dale_hours >= 110, "computer_min")
m.addConstr(-1 * laura_hours + 6 * dale_hours >= 0, "laura_dale_ratio")

m.addConstr(4.87 * laura_hours + 1.72 * dale_hours <= 92, "productivity_max")
m.addConstr(0.28 * laura_hours + 6.84 * dale_hours <= 58, "organization_max")
m.addConstr(6.33 * laura_hours + 4.33 * dale_hours <= 37, "paperwork_max")
m.addConstr(5.0 * laura_hours + 3.52 * dale_hours <= 231, "computer_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found')
    print(f"Laura's hours: {laura_hours.x}")
    print(f"Dale's hours: {dale_hours.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print(f'Optimization ended with status {m.status}')

