
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define decision variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="hours_worked_by_Laura")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale")

# Objective function: Maximize 6.13*x0 + 3.02*x1
m.setObjective(6.13*x0 + 3.02*x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(4.87*x0 + 1.72*x1 >= 41, name="productivity_rating_min")
m.addConstr(0.28*x0 + 6.84*x1 >= 18, name="organization_score_min")
m.addConstr(6.33*x0 + 4.33*x1 >= 17, name="paperwork_competence_rating_min")
m.addConstr(5.0*x0 + 3.52*x1 >= 110, name="computer_competence_rating_min")
m.addConstr(-x0 + 6*x1 >= 0, name="mixed_constraint_1")

m.addConstr(4.87*x0 + 1.72*x1 <= 92, name="productivity_rating_max")
m.addConstr(0.28*x0 + 6.84*x1 <= 58, name="organization_score_max")
m.addConstr(6.33*x0 + 4.33*x1 <= 37, name="paperwork_competence_rating_max")
m.addConstr(5.0*x0 + 3.52*x1 <= 231, name="computer_competence_rating_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Laura: {x0.x}")
    print(f"Hours worked by Dale: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
