
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    L = model.addVar(name="hours_worked_by_Laura", lb=0)
    D = model.addVar(name="hours_worked_by_Dale", lb=0)

    # Objective function: Maximize 6.13L + 3.02D
    model.setObjective(6.13*L + 3.02*D, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4.87*L + 1.72*D >= 41, name="productivity_rating_constraint")
    model.addConstr(0.28*L + 6.84*D >= 18, name="organization_score_constraint")
    model.addConstr(6.33*L + 4.33*D >= 17, name="paperwork_competence_rating_constraint")
    model.addConstr(5.0*L + 3.52*D >= 110, name="computer_competence_rating_constraint")
    model.addConstr(-L + 6*D >= 0, name="hours_worked_constraint")
    model.addConstr(4.87*L + 1.72*D <= 92, name="productivity_rating_upper_bound")
    model.addConstr(0.28*L + 6.84*D <= 58, name="organization_score_upper_bound")
    model.addConstr(6.33*L + 4.33*D <= 37, name="paperwork_competence_rating_upper_bound")
    model.addConstr(5.0*L + 3.52*D <= 231, name="computer_competence_rating_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Laura: {L.varValue}")
        print(f"Hours worked by Dale: {D.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
