
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
basil_plants = m.addVar(name="basil_plants", vtype=gp.GRB.INTEGER)
carrots = m.addVar(name="carrots", vtype=gp.GRB.INTEGER)
tulips = m.addVar(name="tulips", vtype=gp.GRB.INTEGER)
carnations = m.addVar(name="carnations", vtype=gp.GRB.INTEGER)
chrysanthemums = m.addVar(name="chrysanthemums", vtype=gp.GRB.INTEGER)
agave = m.addVar(name="agave", vtype=gp.GRB.INTEGER)
strawberry_bushes = m.addVar(name="strawberry_bushes", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(5.12 * basil_plants + 2.21 * carrots + 2.26 * tulips + 
               4.05 * carnations + 6.74 * chrysanthemums + 
               6.53 * agave + 3.54 * strawberry_bushes, gp.GRB.MINIMIZE)

# Add constraints
# Beauty rating constraints
m.addConstr(1.78 * basil_plants + 2.35 * carrots + 9.37 * tulips + 
             7.74 * carnations + 1.43 * chrysanthemums + 
             5.75 * agave + 5.53 * strawberry_bushes <= 275)

m.addConstr(2.4 * basil_plants + 3.0 * carrots + 2.0 * tulips + 
             9.21 * carnations + 5.73 * chrysanthemums + 
             2.77 * agave + 6.42 * strawberry_bushes <= 310)

m.addConstr(5.75 * agave + 5.53 * strawberry_bushes >= 23)
m.addConstr(2.35 * carrots + 9.37 * tulips >= 32)
m.addConstr(7.74 * carnations + 1.43 * chrysanthemums >= 35)
m.addConstr(1.78 * basil_plants + 5.75 * agave >= 35)
m.addConstr(1.78 * basil_plants + 5.53 * strawberry_bushes >= 26)
m.addConstr(1.78 * basil_plants + 1.43 * chrysanthemums >= 29)
m.addConstr(9.37 * tulips + 1.43 * chrysanthemums >= 37)
m.addConstr(9.37 * tulips + 5.75 * agave >= 34)
m.addConstr(7.74 * carnations + 5.75 * agave + 5.53 * strawberry_bushes >= 35)

# Water need constraints
m.addConstr(2.0 * tulips + 2.77 * agave >= 26)
m.addConstr(2.0 * chrysanthemums + 2.77 * agave >= 31)
m.addConstr(9.21 * carnations + 2.77 * agave >= 41)
m.addConstr(3.0 * carrots + 5.73 * chrysanthemums >= 32)
m.addConstr(3.0 * carrots + 2.0 * tulips >= 24)
m.addConstr(2.0 * tulips + 6.42 * strawberry_bushes >= 40)
m.addConstr(2.4 * basil_plants + 9.21 * carnations >= 37)
m.addConstr(2.4 * basil_plants + 6.42 * strawberry_bushes >= 14)
m.addConstr(2.4 * basil_plants + 2.0 * tulips >= 26)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Basil Plants: ", basil_plants.varValue)
    print("Carrots: ", carrots.varValue)
    print("Tulips: ", tulips.varValue)
    print("Carnations: ", carnations.varValue)
    print("Chrysanthemums: ", chrysanthemums.varValue)
    print("Agave: ", agave.varValue)
    print("Strawberry Bushes: ", strawberry_bushes.varValue)
else:
    print("The model is infeasible")
