
import gurobipy as gp

# Create a new model
m = gp.Model("nutrient_optimization")

# Create variables
iron = m.addVar(lb=0, name="iron")
vitamin_k = m.addVar(lb=0, name="vitamin_k")
potassium = m.addVar(lb=0, name="potassium")
vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_b7")

# Set objective function
obj = 6.58 * iron**2 + 4.47 * iron * vitamin_k + 8.39 * iron * vitamin_b7 + 1.1 * vitamin_k**2 + 9.62 * vitamin_k * potassium + 5.28 * vitamin_k * vitamin_b7 + 6.95 * potassium**2 + 9.93 * potassium * vitamin_b7 + 3.62 * iron + 8.76 * vitamin_k + 4.65 * potassium + 1.84 * vitamin_b7
m.setObjective(obj, gp.GRB.MAXIMIZE)

# Add constraints based on resource attributes
resource_data = {
    'r0': {'description': 'cardiovascular support index', 'upper_bound': 265, 'x0': 23, 'x1': 1, 'x2': 11, 'x3': 3},
    'r1': {'description': 'energy stability index', 'upper_bound': 233, 'x0': 17, 'x1': 2, 'x2': 25, 'x3': 27},
    'r2': {'description': 'cognitive performance index', 'upper_bound': 237, 'x0': 27, 'x1': 29, 'x2': 7, 'x3': 24}
}

# Cardiovascular support index constraints
m.addConstr(23 * iron + 1 * vitamin_k + 3 * vitamin_b7 >= 65)
m.addConstr(23 * iron + 11 * potassium + 3 * vitamin_b7 >= 65)
m.addConstr(1 * vitamin_k**2 + 11 * potassium**2 + 3 * vitamin_b7**2 >= 65)
m.addConstr(23 * iron + 1 * vitamin_k + 3 * vitamin_b7 >= 57)
m.addConstr(23 * iron**2 + 11 * potassium**2 + 3 * vitamin_b7**2 >= 57)
m.addConstr(1 * vitamin_k + 11 * potassium + 3 * vitamin_b7 >= 57)
m.addConstr(23 * iron + 1 * vitamin_k + 3 * vitamin_b7 >= 40)
m.addConstr(23 * iron + 11 * potassium + 3 * vitamin_b7 >= 40)
m.addConstr(1 * vitamin_k + 11 * potassium + 3 * vitamin_b7 >= 40)
m.addConstr(23 * iron + 11 * potassium <= 108)
m.addConstr(1 * vitamin_k + 3 * vitamin_b7 <= 172)
m.addConstr(23 * iron + 1 * vitamin_k <= 215)
m.addConstr(1 * vitamin_k + 11 * potassium <= 87)
m.addConstr(11 * potassium + 3 * vitamin_b7 <= 188)
m.addConstr(23 * iron + 1 * vitamin_k + 11 * potassium + 3 * vitamin_b7 <= 188)


# Energy stability index constraints
m.addConstr(2 * vitamin_k + 27 * vitamin_b7 >= 52)
m.addConstr(17 * iron + 2 * vitamin_k + 27 * vitamin_b7 >= 45)
m.addConstr(17 * iron + 27 * vitamin_b7 <= 93)
m.addConstr(17 * iron**2 + 25 * potassium**2 <= 90)
m.addConstr(2 * vitamin_k + 27 * vitamin_b7 <= 93)
m.addConstr(2 * vitamin_k + 25 * potassium + 27 * vitamin_b7 <= 223)
m.addConstr(17 * iron + 2 * vitamin_k + 25 * potassium <= 65)
m.addConstr(17 * iron + 25 * potassium + 27 * vitamin_b7 <= 176)
m.addConstr(17 * iron + 2 * vitamin_k + 25 * potassium + 27 * vitamin_b7 <= 176)

# Cognitive performance index constraints
m.addConstr(27 * iron + 7 * potassium >= 44)
m.addConstr(7 * potassium + 24 * vitamin_b7 >= 30)
m.addConstr(27 * iron**2 + 7 * potassium**2 + 24 * vitamin_b7**2 >= 48)
m.addConstr(29 * vitamin_k + 7 * potassium + 24 * vitamin_b7 >= 48)
m.addConstr(27 * iron + 29 * vitamin_k + 24 * vitamin_b7 >= 48)
m.addConstr(27 * iron + 7 * potassium + 24 * vitamin_b7 >= 54)
m.addConstr(29 * vitamin_k**2 + 7 * potassium**2 + 24 * vitamin_b7**2 >= 54)
m.addConstr(27 * iron**2 + 29 * vitamin_k**2 + 24 * vitamin_b7**2 >= 54)
m.addConstr(27 * iron**2 + 7 * potassium**2 + 24 * vitamin_b7**2 >= 54)
m.addConstr(29 * vitamin_k + 7 * potassium + 24 * vitamin_b7 >= 54)
m.addConstr(27 * iron**2 + 29 * vitamin_k**2 + 24 * vitamin_b7**2 >= 54)
m.addConstr(27 * iron**2 + 29 * vitamin_k**2 <= 168)
m.addConstr(7 * potassium + 24 * vitamin_b7 <= 178)
m.addConstr(29 * vitamin_k**2 + 7 * potassium**2 <= 111)
m.addConstr(27 * iron + 29 * vitamin_k + 7 * potassium + 24 * vitamin_b7 <= 111)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('iron:', iron.x)
    print('vitamin_k:', vitamin_k.x)
    print('potassium:', potassium.x)
    print('vitamin_b7:', vitamin_b7.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

