
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables (assuming all can be non-negative)
x0 = m.addVar(lb=0, name="milligrams_of_iron")
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_K")
x2 = m.addVar(lb=0, name="milligrams_of_potassium")
# x3 must be an integer
x3 = m.addVar(vtype=GRB.INTEGER, lb=0, name="milligrams_of_vitamin_B7")

# Objective function
m.setObjective(6.58*x0**2 + 4.47*x0*x1 + 8.39*x0*x3 + 1.1*x1**2 + 
               9.62*x1*x2 + 5.28*x1*x3 + 6.95*x2**2 + 9.93*x2*x3 + 
               3.62*x0 + 8.76*x1 + 4.65*x2 + 1.84*x3, GRB.MAXIMIZE)

# Example constraints (you need to add all specified in your problem)
# Cardiovascular support index constraints
m.addConstr(23*x0 + x1 + 11*x2 + 3*x3 >= 65)  # Total combined cardiovascular support index from milligrams of iron, vitamin K, and vitamin B7 must be no less than 65
m.addConstr(23*x0 + 11*x2 + 3*x3 >= 65)      # Total combined cardiovascular support index from milligrams of iron, potassium, and vitamin B7 has to be no less than 65

# Energy stability index constraints
m.addConstr(17*x0 + 2*x1 + 25*x2 + 27*x3 >= 45)  # Total combined energy stability index from milligrams of iron, vitamin K, and vitamin B7 has to be no less than 45

# Cognitive performance index constraints
m.addConstr(27*x0 + 29*x1 + 7*x2 + 24*x3 >= 48)  # Total combined cognitive performance index from milligrams of iron, vitamin K, and vitamin B7 must be 48 at minimum

# Bounds (example)
m.addConstr(23*x0 + x1 <= 215)  # Total combined cardiovascular support index from milligrams of iron and vitamin K must be at most 215
m.addConstr(x1 + 11*x2 <= 87)   # Total combined cardiovascular support index from milligrams of vitamin K plus potassium should be 87 at a maximum

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of iron: {x0.x}")
    print(f"Milligrams of vitamin K: {x1.x}")
    print(f"Milligrams of potassium: {x2.x}")
    print(f"Milligrams of vitamin B7: {x3.x}")
else:
    print("No optimal solution found")
