
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
mary = m.addVar(name="Mary", lb=0)
dale = m.addVar(name="Dale", lb=0)
paul = m.addVar(name="Paul", lb=0)
laura = m.addVar(name="Laura", lb=0)
bobby = m.addVar(name="Bobby", lb=0)

# Set objective function
m.setObjective(4 * mary + 4 * dale + 7 * paul + 5 * laura + 1 * bobby, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(18 * dale + 11 * bobby >= 39, "c1")
m.addConstr(19 * mary + 4 * laura >= 44, "c2")
m.addConstr(19 * mary + 11 * bobby >= 94, "c3")
m.addConstr(19 * mary + 18 * dale + 9 * paul >= 107, "c4")
m.addConstr(19 * mary + 18 * dale + 9 * paul + 4 * laura + 11 * bobby >= 107, "c5")
m.addConstr(15 * laura + 4 * bobby >= 113, "c6")
m.addConstr(22 * mary + 4 * bobby >= 86, "c7")
m.addConstr(16 * paul + 4 * bobby >= 86, "c8")
m.addConstr(24 * dale + 16 * paul + 4 * bobby >= 87, "c9")
m.addConstr(22 * mary + 24 * dale + 15 * laura >= 87, "c10")
m.addConstr(24 * dale + 15 * laura + 4 * bobby >= 87, "c11")
m.addConstr(24 * dale + 16 * paul + 4 * bobby >= 94, "c12")
m.addConstr(22 * mary + 24 * dale + 15 * laura >= 94, "c13")
m.addConstr(24 * dale + 15 * laura + 4 * bobby >= 94, "c14")
m.addConstr(24 * dale + 16 * paul + 4 * bobby >= 77, "c15")
m.addConstr(22 * mary + 24 * dale + 15 * laura >= 77, "c16")
m.addConstr(24 * dale + 15 * laura + 4 * bobby >= 77, "c17")
m.addConstr(22 * mary + 24 * dale + 16 * paul + 15 * laura + 4 * bobby >= 77, "c18")
m.addConstr(2 * laura + 6 * bobby >= 51, "c19")
m.addConstr(10 * mary + 6 * bobby >= 51, "c20")
m.addConstr(7 * dale + 7 * paul >= 79, "c24")
m.addConstr(7 * dale + 2 * laura >= 52, "c25")
m.addConstr(10 * mary + 7 * paul >= 96, "c26")
m.addConstr(7 * paul + 6 * bobby >= 108, "c27")
m.addConstr(10 * mary + 7 * dale + 7 * paul + 2 * laura + 6 * bobby >= 108, "c28")
m.addConstr(7 * dale + 2 * laura <= 582, "c35")
m.addConstr(7 * paul + 2 * laura <= 183, "c36")


m.addConstr(6 * dale - 6 * bobby >= 0, "c29")
m.addConstr(-2 * mary + 3 * paul >= 0, "c30")

m.addConstr(10*mary + 7*dale <= 582, "c23") # Corrected constraint

# Resource constraints (using provided data)
m.addConstr(19 * mary + 18 * dale + 9 * paul <= 537, "r0") # Organization score
m.addConstr(22 * mary + 24 * dale + 16 * paul + 15 * laura + 4 * bobby <= 586, "r1") # Dollar cost
m.addConstr(10 * mary + 7 * dale + 7 * paul + 2 * laura + 6 * bobby <= 650, "r2") # Computer competence


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

