
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x_B = model.addVar(lb=0, name="hours_worked_by_Bill")
    x_P = model.addVar(lb=0, name="hours_worked_by_Peggy")
    x_H = model.addVar(lb=0, name="hours_worked_by_Hank")

    # Objective function
    model.setObjective(x_B**2 + 9*x_B*x_P + 8*x_P**2 + x_P*x_H + 7*x_P + 7*x_H)

    # Constraints
    model.addConstr(0.46 * x_B <= 144)
    model.addConstr(1.82 * x_B <= 116)
    model.addConstr(6.95 * x_B <= 152)
    model.addConstr(8.81 * x_B <= 76)
    model.addConstr(4.17 * x_B <= 99)

    model.addConstr(6.72 * x_P <= 144)
    model.addConstr(2.03 * x_P <= 116)
    model.addConstr(1.29 * x_P <= 152)
    model.addConstr(1.9 * x_P <= 76)
    model.addConstr(10.11 * x_P <= 99)

    model.addConstr(10.12 * x_H <= 144)
    model.addConstr(5.95 * x_H <= 116)
    model.addConstr(12.71 * x_H <= 152)
    model.addConstr(9.2 * x_H <= 76)
    model.addConstr(0.97 * x_H <= 99)

    model.addConstr(0.46 * x_B**2 + 10.12 * x_H**2 >= 39)
    model.addConstr(6.72 * x_P + 10.12 * x_H >= 18)
    model.addConstr(0.46 * x_B + 6.72 * x_P + 10.12 * x_H >= 18)
    model.addConstr(1.82 * x_B + 2.03 * x_P >= 16)
    model.addConstr(2.03 * x_P + 5.95 * x_H >= 36)
    model.addConstr(1.82 * x_B + 2.03 * x_P + 5.95 * x_H >= 34)
    model.addConstr(6.95 * x_B + 12.71 * x_H >= 31)
    model.addConstr(6.95 * x_B + 1.29 * x_P >= 47)
    model.addConstr(6.95 * x_B + 1.29 * x_P + 12.71 * x_H >= 47)
    model.addConstr(8.81 * x_B**2 + 9.2 * x_H**2 >= 11)
    model.addConstr(8.81 * x_B + 1.9 * x_P >= 14)
    model.addConstr(8.81 * x_B + 1.9 * x_P + 9.2 * x_H >= 14)
    model.addConstr(4.17 * x_B + 10.11 * x_P >= 31)
    model.addConstr(10.11 * x_P**2 + 0.97 * x_H**2 >= 30)
    model.addConstr(4.17 * x_B + 10.11 * x_P + 0.97 * x_H >= 30)
    model.addConstr(5 * x_P - 5 * x_H >= 0)
    model.addConstr(2.03 * x_P + 5.95 * x_H <= 88)
    model.addConstr(1.82 * x_B**2 + 2.03 * x_P**2 <= 54)
    model.addConstr(4.17 * x_B + 10.11 * x_P <= 62)
    model.addConstr(4.17**2 * x_B**2 + 10.11**2 * x_P**2 + 0.97**2 * x_H**2 <= 96)

    # Solve the problem
    model.optimize()

    # Output the solution
    if model.status == gurobi.GRB_OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Bill: {x_B.varValue}")
        print(f"Hours worked by Peggy: {x_P.varValue}")
        print(f"Hours worked by Hank: {x_H.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB_INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("No optimal solution exists.")

optimize_problem()
