
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
patches_per_day = m.addVar(vtype=GRB.INTEGER, name="patches_per_day")
system_administrators = m.addVar(vtype=GRB.INTEGER, name="system_administrators")
automatic_alerts = m.addVar(vtype=GRB.INTEGER, name="automatic_alerts")
intrusion_analysts = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")

# Set objective function
m.setObjective(2.34 * patches_per_day + 2.43 * system_administrators + 2.6 * automatic_alerts + 8.27 * intrusion_analysts, GRB.MINIMIZE)

# Add constraints
m.addConstr(10 * patches_per_day + 6 * system_administrators + 12 * automatic_alerts + 14 * intrusion_analysts <= 190, "r0_network_latency_impact")
m.addConstr(9 * patches_per_day + 13 * system_administrators + 2 * automatic_alerts + 5 * intrusion_analysts <= 183, "r1_network_integrity_impact")
m.addConstr(11 * patches_per_day + 13 * system_administrators + 12 * automatic_alerts + 8 * intrusion_analysts <= 223, "r2_data_confidentiality_impact")
m.addConstr(5 * patches_per_day + 12 * system_administrators + 10 * automatic_alerts + 11 * intrusion_analysts <= 204, "r3_computational_load")

m.addConstr(10 * patches_per_day + 14 * intrusion_analysts >= 20, "c1")
m.addConstr(10 * patches_per_day + 12 * automatic_alerts >= 30, "c2")
m.addConstr(6 * system_administrators + 14 * intrusion_analysts >= 30, "c3")
m.addConstr(10 * patches_per_day + 6 * system_administrators + 12 * automatic_alerts >= 36, "c4")
m.addConstr(10 * patches_per_day + 12 * automatic_alerts + 14 * intrusion_analysts >= 36, "c5")
m.addConstr(6 * system_administrators + 12 * automatic_alerts + 14 * intrusion_analysts >= 36, "c6")
m.addConstr(10 * patches_per_day + 6 * system_administrators + 12 * automatic_alerts >= 46, "c7")
m.addConstr(10 * patches_per_day + 12 * automatic_alerts + 14 * intrusion_analysts >= 46, "c8")
m.addConstr(6 * system_administrators + 12 * automatic_alerts + 14 * intrusion_analysts >= 46, "c9")
m.addConstr(10 * patches_per_day + 6 * system_administrators + 12 * automatic_alerts >= 44, "c10")
m.addConstr(10 * patches_per_day + 12 * automatic_alerts + 14 * intrusion_analysts >= 44, "c11")
m.addConstr(6 * system_administrators + 12 * automatic_alerts + 14 * intrusion_analysts >= 44, "c12")
m.addConstr(10 * patches_per_day + 6 * system_administrators + 12 * automatic_alerts + 14 * intrusion_analysts >= 44, "c13")

m.addConstr(9 * patches_per_day + 2 * automatic_alerts >= 45, "c14")
m.addConstr(9 * patches_per_day + 13 * system_administrators + 5 * intrusion_analysts >= 29, "c15")
m.addConstr(9 * patches_per_day + 2 * automatic_alerts + 5 * intrusion_analysts >= 29, "c16")
m.addConstr(9 * patches_per_day + 13 * system_administrators + 5 * intrusion_analysts >= 23, "c17")
m.addConstr(9 * patches_per_day + 2 * automatic_alerts + 5 * intrusion_analysts >= 23, "c18")
m.addConstr(9 * patches_per_day + 13 * system_administrators + 2 * automatic_alerts + 5 * intrusion_analysts >= 23, "c19")


m.addConstr(11 * patches_per_day + 8 * intrusion_analysts >= 33, "c20")
m.addConstr(11 * patches_per_day + 13 * system_administrators >= 49, "c21")
m.addConstr(11 * patches_per_day + 12 * automatic_alerts >= 46, "c22")
m.addConstr(13 * system_administrators + 12 * automatic_alerts >= 32, "c23")
m.addConstr(13 * system_administrators + 8 * intrusion_analysts >= 33, "c24")
m.addConstr(11 * patches_per_day + 13 * system_administrators + 12 * automatic_alerts >= 45, "c25")
m.addConstr(11 * patches_per_day + 13 * system_administrators + 12 * automatic_alerts + 8 * intrusion_analysts >= 45, "c26")

m.addConstr(5 * patches_per_day + 11 * intrusion_analysts >= 29, "c27")
m.addConstr(10 * automatic_alerts + 11 * intrusion_analysts >= 30, "c28")
m.addConstr(5 * patches_per_day + 12 * system_administrators >= 19, "c29")
m.addConstr(12 * system_administrators + 10 * automatic_alerts >= 29, "c30")
m.addConstr(5 * patches_per_day + 12 * system_administrators + 10 * automatic_alerts >= 44, "c31")
m.addConstr(5 * patches_per_day + 12 * system_administrators + 10 * automatic_alerts + 11 * intrusion_analysts >= 44, "c32")

m.addConstr(-10 * automatic_alerts + 1 * intrusion_analysts >= 0, "c33")
m.addConstr(-8 * patches_per_day + 1 * system_administrators >= 0, "c34")

m.addConstr(10 * patches_per_day + 6 * system_administrators + 14 * intrusion_analysts <= 127, "c35")
m.addConstr(10 * patches_per_day + 6 * system_administrators + 12 * automatic_alerts <= 90, "c36")
m.addConstr(6 * system_administrators + 12 * automatic_alerts + 14 * intrusion_analysts <= 116, "c37")
m.addConstr(13 * system_administrators + 2 * automatic_alerts + 5 * intrusion_analysts <= 151, "c38")
m.addConstr(5 * patches_per_day + 12 * system_administrators + 10 * automatic_alerts <= 110, "c39")
m.addConstr(5 * patches_per_day + 12 * system_administrators + 11 * intrusion_analysts <= 156, "c40")
m.addConstr(12 * system_administrators + 10 * automatic_alerts + 11 * intrusion_analysts <= 138, "c41")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
