
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_b2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b2")
iron = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="iron")
vitamin_b6 = m.addVar(lb=0, vtype=GRB.INTEGER, name="vitamin_b6")
vitamin_b4 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b4")
vitamin_b7 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b7")
carbohydrates = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="carbohydrates")

# Set objective function
m.setObjective(3*vitamin_b2 + 7*iron + 8*vitamin_b6 + 2*vitamin_b4 + 9*vitamin_b7 + 7*carbohydrates, GRB.MINIMIZE)

# Resource constraints
resources = {
    'r0': {'upper_bound': 164, 'x0': 6, 'x1': 12, 'x2': 4, 'x3': 13, 'x4': 7, 'x5': 13},
    'r1': {'upper_bound': 198, 'x0': 2, 'x1': 14, 'x2': 8, 'x3': 6, 'x4': 6, 'x5': 3},
    'r2': {'upper_bound': 168, 'x0': 7, 'x1': 11, 'x2': 2, 'x3': 9, 'x4': 9, 'x5': 3}
}

for r_key, r_data in resources.items():
    m.addConstr(r_data['x0']*vitamin_b2 + r_data['x1']*iron + r_data['x2']*vitamin_b6 + r_data['x3']*vitamin_b4 + r_data['x4']*vitamin_b7 + r_data['x5']*carbohydrates <= r_data['upper_bound'], name=f"{r_key}_constraint")


# Additional constraints (simplified and deduplicated)
m.addConstr(12 * iron + 4 * vitamin_b6 >= 16)
m.addConstr(12 * iron + 13 * carbohydrates >= 16)
m.addConstr(6 * vitamin_b2 + 4 * vitamin_b6 >= 12)
m.addConstr(6 * vitamin_b2 + 7 * vitamin_b7 >= 20)
m.addConstr(6 * vitamin_b2 + 13 * carbohydrates >= 14)
m.addConstr(13 * vitamin_b4 + 13 * carbohydrates >= 14)
m.addConstr(4 * vitamin_b6 + 13 * vitamin_b4 >= 18)
m.addConstr(12 * iron + 7 * vitamin_b7 >= 21)
m.addConstr(4 * vitamin_b6 + 13 * carbohydrates >= 17)
m.addConstr(6 * vitamin_b2 + 12 * iron + 4 * vitamin_b6 + 13 * vitamin_b4 + 7 * vitamin_b7 + 13 * carbohydrates >= 17)
m.addConstr(8 * vitamin_b6 + 3 * carbohydrates >= 22)
m.addConstr(14 * iron + 8 * vitamin_b6 >= 13)
m.addConstr(14 * iron + 6 * vitamin_b4 >= 12)
m.addConstr(2 * vitamin_b2 + 3 * carbohydrates >= 27)
m.addConstr(6 * vitamin_b7 + 3 * carbohydrates >= 29)
m.addConstr(6 * vitamin_b4 + 3 * carbohydrates >= 29)
m.addConstr(2 * vitamin_b2 + 14 * iron >= 30)
m.addConstr(14 * iron + 6 * vitamin_b7 >= 28)
m.addConstr(14 * iron + 8 * vitamin_b6 + 6 * vitamin_b7 >= 31)
m.addConstr(14 * iron + 6 * vitamin_b7 + 3 * carbohydrates >= 31)
m.addConstr(9 * vitamin_b4 + 9 * vitamin_b7 >= 18)
m.addConstr(7 * vitamin_b2 + 3 * carbohydrates >= 17)
m.addConstr(7 * vitamin_b2 + 9 * vitamin_b7 >= 12)
m.addConstr(9 * vitamin_b4 + 3 * carbohydrates >= 20)
m.addConstr(11 * iron + 9 * vitamin_b7 >= 14)
m.addConstr(7 * vitamin_b2 + 9 * vitamin_b4 >= 26)
m.addConstr(9 * vitamin_b7 + 3 * carbohydrates >= 15)
m.addConstr(7 * vitamin_b2 + 2 * vitamin_b6 >= 9)
m.addConstr(2 * vitamin_b6 + 9 * vitamin_b7 >= 24)
m.addConstr(2 * vitamin_b6 + 9 * vitamin_b4 >= 27)
m.addConstr(4 * vitamin_b7 - 8 * carbohydrates >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {m.status}")
