
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hot_dogs = m.addVar(lb=0, name="hot_dogs")
bananas = m.addVar(lb=0, name="bananas")
ham_sandwiches = m.addVar(lb=0, name="ham_sandwiches")
eggs = m.addVar(lb=0, name="eggs")

# Set objective function
m.setObjective(5*hot_dogs**2 + 4*hot_dogs*bananas + 3*hot_dogs*ham_sandwiches + 5*hot_dogs*eggs + 9*bananas**2 + 1*bananas*ham_sandwiches + 2*bananas*eggs + 5*ham_sandwiches**2 + 6*ham_sandwiches*eggs + 5*eggs**2 + 6*hot_dogs + 1*bananas + 5*ham_sandwiches + 4*eggs, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(12*hot_dogs + 17*eggs >= 39, "fiber_constraint1")
m.addConstr(12*hot_dogs + 16*bananas >= 21, "fiber_constraint2")
m.addConstr(9*ham_sandwiches + 17*eggs >= 33, "fiber_constraint3")
m.addConstr(16*bananas + 9*ham_sandwiches + 17*eggs >= 34, "fiber_constraint4")
m.addConstr(12*hot_dogs + 16*bananas + 9*ham_sandwiches + 17*eggs >= 34, "fiber_constraint5")
m.addConstr(12*hot_dogs + 16*bananas + 9*ham_sandwiches + 17*eggs <= 133, "fiber_constraint6")


m.addConstr(5*bananas + 12*eggs >= 13, "umami_constraint1")
m.addConstr(16*hot_dogs + 5*bananas >= 8, "umami_constraint2")
m.addConstr(16*hot_dogs**2 + 5*bananas**2 + 12*eggs**2 >= 22, "umami_constraint3")
m.addConstr(16*hot_dogs + 5*bananas + 12*ham_sandwiches + 12*eggs >= 22, "umami_constraint4")

m.addConstr(8*ham_sandwiches + 1*eggs >= 53, "sourness_constraint1")
m.addConstr(14*bananas**2 + 8*ham_sandwiches**2 >= 87, "sourness_constraint2")
m.addConstr(13*hot_dogs + 8*ham_sandwiches >= 53, "sourness_constraint3")
m.addConstr(13*hot_dogs + 14*bananas + 8*ham_sandwiches + 1*eggs >= 53, "sourness_constraint4")

m.addConstr(13*hot_dogs + 8*ham_sandwiches <= 87, "sourness_constraint5")
m.addConstr(13*hot_dogs + 14*bananas <= 192, "sourness_constraint6")
m.addConstr(14*bananas + 8*ham_sandwiches <= 155, "sourness_constraint7")
m.addConstr(8*ham_sandwiches + 1*eggs <= 208, "sourness_constraint8")


m.addConstr(5*ham_sandwiches - 9*eggs >= 0, "constraint1")
m.addConstr(7*bananas**2 - 9*eggs**2 >= 0, "constraint2")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

