
import gurobipy as gp

# Create a new model
m = gp.Model("fiber_optimization")

# Create variables
granola_bars = m.addVar(lb=0, name="granola_bars")
eggs = m.addVar(lb=0, name="eggs")
oreos = m.addVar(lb=0, name="oreos")
apple_pies = m.addVar(lb=0, name="apple_pies")
lemons = m.addVar(lb=0, name="lemons")
kiwis = m.addVar(lb=0, name="kiwis")

# Set objective function
m.setObjective(3.55 * granola_bars + 3.57 * eggs + 2.41 * oreos + 7.83 * apple_pies + 5.78 * lemons + 8.69 * kiwis, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(11 * granola_bars + 13 * eggs + 27 * oreos + 2 * apple_pies + 32 * lemons + 24 * kiwis <= 327, "max_fiber")
m.addConstr(11 * granola_bars + 32 * lemons >= 26, "fiber_granola_lemons")
m.addConstr(13 * eggs + 2 * apple_pies >= 54, "fiber_eggs_apple_pies")
m.addConstr(2 * apple_pies + 24 * kiwis >= 50, "fiber_apple_pies_kiwis")
m.addConstr(11 * granola_bars + 2 * apple_pies >= 47, "fiber_granola_apple_pies")
m.addConstr(11 * granola_bars + 13 * eggs + 27 * oreos + 2 * apple_pies + 32 * lemons + 24 * kiwis >= 47, "fiber_all")
m.addConstr(4 * eggs - 6 * apple_pies >= 0, "eggs_apple_pies_ratio")
m.addConstr(4 * eggs - 6 * kiwis >= 0, "eggs_kiwis_ratio")
m.addConstr(-8 * eggs + 2 * oreos + 8 * lemons >= 0, "eggs_oreos_lemons_ratio")
m.addConstr(27 * oreos + 2 * apple_pies + 32 * lemons <= 207, "max_fiber_subset")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

