
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="granola_bars")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="eggs")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oreos")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_pies")
x4 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="lemons")
x5 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kiwis")

# Set objective function
m.setObjective(3.55*x0 + 3.57*x1 + 2.41*x2 + 7.83*x3 + 5.78*x4 + 8.69*x5, GRB.MINIMIZE)

# Add constraints
m.addConstr(11*x0 + 32*x4 >= 26, name="constraint_1")
m.addConstr(13*x1 + 2*x3 >= 54, name="constraint_2")
m.addConstr(2*x3 + 24*x5 >= 50, name="constraint_3")
m.addConstr(11*x0 + 2*x3 >= 47, name="constraint_4")
m.addConstr(11*x0 + 13*x1 + 27*x2 + 2*x3 + 32*x4 + 24*x5 <= 327, name="constraint_5")
m.addConstr(11*x0 + 13*x1 + 27*x2 + 2*x3 + 32*x4 + 24*x5 >= 47, name="constraint_6")
m.addConstr(4*x1 - 6*x3 >= 0, name="constraint_7")
m.addConstr(4*x1 - 6*x5 >= 0, name="constraint_8")
m.addConstr(-8*x1 + 2*x2 + 8*x4 >= 0, name="constraint_9")
m.addConstr(27*x2 + 2*x3 + 32*x4 <= 207, name="constraint_10")

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print('%s %g' % (v.varName, v.x))
