
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="grams_carbohydrates")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mg_magnesium")

    # Set objective function
    m.setObjective(4 * x0 + 9 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(7 * x0 + 3 * x1 >= 36, "cardio_min")
    m.addConstr(7 * x0 + 3 * x1 <= 103, "cardio_max")
    m.addConstr(10 * x0 + 1 * x1 >= 40, "immune_min")
    m.addConstr(10 * x0 + 1 * x1 <= 78, "immune_max")
    m.addConstr(3 * x0 + 13 * x1 >= 70, "energy_min")
    m.addConstr(3 * x0 + 13 * x1 <= 143, "energy_max")
    m.addConstr(-10 * x0 + 5 * x1 >= 0, "additional_constraint")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Grams of Carbohydrates: {x0.x}")
        print(f"Milligrams of Magnesium: {x1.x}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
