
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="grams_of_carbohydrates")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_magnesium")

# Objective function: Maximize 4*x0 + 9*x1
m.setObjective(4*x0 + 9*x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(7*x0 + 3*x1 >= 36, "cardiovascular_support_index_min")
m.addConstr(7*x0 + 3*x1 <= 103, "cardiovascular_support_index_max")

m.addConstr(10*x0 + x1 >= 40, "immune_support_index_min")
m.addConstr(10*x0 + x1 <= 78, "immune_support_index_max")

m.addConstr(3*x0 + 13*x1 >= 70, "energy_stability_index_min")
m.addConstr(3*x0 + 13*x1 <= 143, "energy_stability_index_max")

m.addConstr(-10*x0 + 5*x1 >= 0, "additional_constraint")

# Solve the model
m.optimize()

if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of carbohydrates: {x0.x}")
    print(f"Milligrams of magnesium: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
