
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INF, ub=gurobi.GRB.INF, name="grams_of_carbohydrates")
    x1 = model.addVar(lb=-gurobi.GRB.INF, ub=gurobi.GRB.INF, name="milligrams_of_magnesium")

    # Objective function: Maximize 4*x0 + 9*x1
    model.setObjective(4*x0 + 9*x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Total cardiovascular support index >= 36
    model.addConstr(7*x0 + 3*x1 >= 36, name="cardiovascular_support_index_min")
    # Total cardiovascular support index <= 103
    model.addConstr(7*x0 + 3*x1 <= 103, name="cardiovascular_support_index_max")

    # Total immune support index >= 40
    model.addConstr(10*x0 + 1*x1 >= 40, name="immune_support_index_min")
    # Total immune support index <= 78
    model.addConstr(10*x0 + 1*x1 <= 78, name="immune_support_index_max")

    # Total energy stability index >= 70
    model.addConstr(3*x0 + 13*x1 >= 70, name="energy_stability_index_min")
    # Total energy stability index <= 143
    model.addConstr(3*x0 + 13*x1 <= 143, name="energy_stability_index_max")

    # Additional constraint: -10*x0 + 5*x1 >= 0
    model.addConstr(-10*x0 + 5*x1 >= 0, name="additional_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Grams of carbohydrates: {x0.varValue}")
        print(f"Milligrams of magnesium: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible.")

optimize_problem()
