
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
vitamin_c = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_c")
vitamin_b12 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b12")

# Set objective function
model.setObjective(8.21 * vitamin_c + 1.87 * vitamin_b12, GRB.MAXIMIZE)

# Add constraints
model.addConstr(12.75 * vitamin_c + 7.81 * vitamin_b12 >= 47, "muscle_growth_min")
model.addConstr(0.69 * vitamin_c + 1.13 * vitamin_b12 >= 22, "digestive_support_min")
model.addConstr(6 * vitamin_c - 3 * vitamin_b12 >= 0, "custom_constraint")
model.addConstr(12.75 * vitamin_c + 7.81 * vitamin_b12 <= 87, "muscle_growth_max")
model.addConstr(0.69 * vitamin_c + 1.13 * vitamin_b12 <= 52, "digestive_support_max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Milligrams of Vitamin C: {vitamin_c.x}")
    print(f"Milligrams of Vitamin B12: {vitamin_b12.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

