
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define variables
vitamin_C = model.addVar(name="vitamin_C", lb=0)  # Lower bound is 0
vitamin_B12 = model.addVar(name="vitamin_B12", lb=0)  # Lower bound is 0

# Objective function: Maximize 8.21 * vitamin_C + 1.87 * vitamin_B12
model.setObjective(8.21 * vitamin_C + 1.87 * vitamin_B12, gurobi.GRB.MAXIMIZE)

# Constraints
# The muscle growth index of milligrams of vitamin C is 12.75 (not a constraint, but a given attribute)
# The muscle growth index of milligrams of vitamin B12 is 7.81 (not a constraint, but a given attribute)
# The digestive support index of milligrams of vitamin C is 0.69 (not a constraint, but a given attribute)
# The digestive support index of milligrams of vitamin B12 is 1.13 (not a constraint, but a given attribute)

# 5. The total combined muscle growth index must be at least 47
model.addConstr(12.75 * vitamin_C + 7.81 * vitamin_B12 >= 47)

# 6. The total combined digestive support index should be greater than or equal to 22
model.addConstr(0.69 * vitamin_C + 1.13 * vitamin_B12 >= 22)

# 7. Six times the number of milligrams of vitamin C, plus -3 times the number of milligrams of vitamin B12, should be at least zero
model.addConstr(6 * vitamin_C - 3 * vitamin_B12 >= 0)

# 8 & 9. The total combined muscle growth index and digestive support index have upper bounds
model.addConstr(12.75 * vitamin_C + 7.81 * vitamin_B12 <= 87)
model.addConstr(0.69 * vitamin_C + 1.13 * vitamin_B12 <= 52)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin C: {vitamin_C.varValue}")
    print(f"Milligrams of vitamin B12: {vitamin_B12.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
