
import gurobipy as gp

# Create a new model
m = gp.Model("Work Allocation")

# Create variables
bill_hours = m.addVar(name="bill_hours", nonneg=True)
mary_hours = m.addVar(name="mary_hours", nonneg=True)
hank_hours = m.addVar(name="hank_hours", nonneg=True)

# Set objective function
m.setObjective(9.62 * bill_hours + 6.74 * mary_hours + 7.61 * hank_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4.81 * bill_hours + 10.91 * mary_hours >= 18, "likelihood_to_quit_bill_mary")
m.addConstr(4.81 * bill_hours + 10.91 * mary_hours + 7.87 * hank_hours >= 18, "likelihood_to_quit_total")
m.addConstr(10.28 * bill_hours + 0.89 * mary_hours + 11.33 * hank_hours >= 34, "paperwork_competence_total")
m.addConstr(0.62 * bill_hours + 8.79 * hank_hours >= 14, "work_quality_bill_hank")
m.addConstr(11.77 * mary_hours + 8.79 * hank_hours >= 37, "work_quality_mary_hank")
m.addConstr(5.35 * bill_hours + 8.39 * mary_hours + 11.28 * hank_hours >= 28, "dollar_cost_total")
m.addConstr(11.19 * mary_hours + 9.05 * hank_hours <= 75, "organization_score_mary_hank")
m.addConstr(9.76 * bill_hours + 11.19 * mary_hours + 9.05 * hank_hours <= 75, "organization_score_total")
m.addConstr(4.81 * bill_hours + 7.87 * hank_hours <= 51, "likelihood_to_quit_bill_hank")
m.addConstr(4.81 * bill_hours + 10.91 * mary_hours + 7.87 * hank_hours <= 51, "likelihood_to_quit_total_max")
m.addConstr(10.28 * bill_hours + 11.33 * hank_hours <= 83, "paperwork_competence_bill_hank")
m.addConstr(0.89 * mary_hours + 11.33 * hank_hours <= 64, "paperwork_competence_mary_hank")
m.addConstr(10.28 * bill_hours + 0.89 * mary_hours + 11.33 * hank_hours <= 64, "paperwork_competence_total_max")
m.addConstr(0.62 * bill_hours + 8.79 * hank_hours <= 38, "work_quality_bill_hank_max")
m.addConstr(11.77 * mary_hours + 8.79 * hank_hours <= 86, "work_quality_mary_hank_max")
m.addConstr(0.62 * bill_hours + 11.77 * mary_hours + 8.79 * hank_hours <= 86, "work_quality_total_max")
m.addConstr(5.35 * bill_hours + 8.39 * mary_hours <= 105, "dollar_cost_bill_mary")
m.addConstr(5.35 * bill_hours + 11.28 * hank_hours <= 110, "dollar_cost_bill_hank")
m.addConstr(5.35 * bill_hours + 8.39 * mary_hours + 11.28 * hank_hours <= 110, "dollar_cost_total_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found:')
    print('Bill hours:', bill_hours.x)
    print('Mary hours:', mary_hours.x)
    print('Hank hours:', hank_hours.x)
    print('Objective value:', m.objVal)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print('Optimization ended with status:', m.status)

